package ibase.webitm.ejb.dis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.ITMUploadFileRemote;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SCMWebServiceDao extends ValidatorEJB
{
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	
	public String addTransaction(String dataXML, String userCode) throws ITMException
	{
		String retString = "";
		ITMUploadFileRemote imtUploadFileRemote = null;
		DBAccessLocal dbAccessEJBLocal = null;
		UserInfoBean userInfoBean = null;
		Document errDom = null, dataXMLDom = null;
		StringBuffer retSBuff = new StringBuffer("<Root>");
		File dumpDir = null;
		File logDumpDir = null;
		try
		{
			System.out.println("SCMWebServiceDao.addTransaction().dataXML["+dataXML+"]");
			System.out.println("SCMWebServiceDao.addTransaction().userCode["+userCode+"]");
			
			dbAccessEJBLocal = (DBAccessLocal)getInitialContext().lookup("ibase/DBAccessEJB/local"); 
			userInfoBean = dbAccessEJBLocal.createUserInfo(userCode);
			
			if(dataXML != null && dataXML.trim().length() > 0)
			{
				dataXMLDom = e12GenericUtility.parseString(dataXML);
				Node detail1Node = dataXMLDom.getElementsByTagName("Detail1").item(0);
				String objName = detail1Node.getAttributes().getNamedItem("objName").getNodeValue();
				System.out.println("objName["+objName+"]");
				
				if( CommonConstants.UPLOAD_LOC == null && CommonConstants.J2EE_VERSION.equals( "1" ))
				{
					System.out.println("UPLOAD_LOC is null");
					dumpDir = new File(( new File( CommonConstants.APPLICATION_CONTEXT ) ).getParentFile().getParent() + File.separator + "dump" );				
					logDumpDir = new File( dumpDir .getParent()  + File.separator + "logs") ;
				}
				else
				{
					 System.out.println("DUMP LOG::");
					dumpDir = new File( ( new File( CommonConstants.UPLOAD_LOC ) ) + File.separator + "dump" );
					if ( ! dumpDir.exists() )
					{
						dumpDir.mkdir();
					}
					
					logDumpDir = new File( ( new File( CommonConstants.UPLOAD_LOC ) ) + File.separator + "logs" );
					if ( ! logDumpDir.exists() )
					{
						logDumpDir.mkdir();
					}
				}
				
				String newFileName = System.currentTimeMillis() + "_" + userInfoBean.getLoginCode() + "_hdr_det_data.xml";
				
				BufferedWriter writer = null;
				try
				{
				    writer = new BufferedWriter( new FileWriter( dumpDir.getAbsolutePath() + File.separator + newFileName));
				    writer.write( dataXML);
				}
				catch ( IOException e)
				{
					System.out.println("SCMWebServiceDao.addTransaction().writer closing exption in catch["+e.getMessage()+"]");
				}
				finally
				{
				    try
				    {
				        if ( writer != null)
				        {
				        	writer.close();
				        }
				    }
				    catch ( IOException e)
				    {
				    	System.out.println("writer closing exception in finally["+e.getMessage()+"]");
				    }
				}
				
				String [] fileInfoArr = new String[8];
				fileInfoArr[0] =  "false";
				fileInfoArr[1] = newFileName;
				fileInfoArr[2] = objName;
				fileInfoArr[3] = "";
				fileInfoArr[4] = "";
				fileInfoArr[5] = "false";
				fileInfoArr[6] = "false";
				fileInfoArr[7] = "true";

				imtUploadFileRemote = (ITMUploadFileRemote) getInitialContext().lookup("ibase/ITMUploadFileEJB/remote");
				retString = imtUploadFileRemote.insertFileData(fileInfoArr , userInfoBean , dumpDir , CommonConstants.APPLICATION_CONTEXT, "", false, false);
				
				System.out.println("retString after upload call["+retString+"]");
				
				
				if(retString != null && retString.trim().length()>0 && retString.indexOf("<Errors>") >-1)
				{
					errDom = e12GenericUtility.parseString(retString);
					
					NodeList errNodeList = errDom.getElementsByTagName("error");
					int errNodeListLen = errNodeList.getLength();
					
					for(int i=0; i<errNodeListLen; i++)
					{
						String errorMessage = "";
						Node eachErrNode = errNodeList.item(i);
						NodeList eachErrNodeList = eachErrNode.getChildNodes();
						int eachErrNodeListLen = eachErrNodeList.getLength();
						
						String msgNo = eachErrNode.getAttributes().getNamedItem("id").getNodeValue();
						System.out.println("msgNo["+msgNo+"]");
						for(int j=0; j<eachErrNodeListLen; j++)
						{
							Node eachNode = eachErrNodeList.item(j);
							String nodeName = eachNode.getNodeName();
							String nodeValue = eachNode.getFirstChild() != null ? eachNode.getFirstChild().getNodeValue():"";
							
							if("description".equalsIgnoreCase(nodeName))
							{
								errorMessage = nodeValue;
							}
						}
						retSBuff.append("<tran_id><![CDATA[]]></tran_id>");
						retSBuff.append("<msg_code><![CDATA["+msgNo+"]]></msg_code>");
						retSBuff.append("<msg_descr><![CDATA["+errorMessage+"]]></msg_descr>");
						retSBuff.append("<result><![CDATA[FAILED]]></result>");
					}
				}
				else
				{
					if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
					{
					    String tranId = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
					    
					    retSBuff.append("<tran_id><![CDATA["+tranId+"]]></tran_id>");
						retSBuff.append("<msg_code><![CDATA[]]></msg_code>");
						retSBuff.append("<msg_descr><![CDATA[Transaction is saved]]></msg_descr>");
						retSBuff.append("<result><![CDATA[SUCCESS]]></result>");
					}
				}
				retSBuff.append("</Root>");
				
				retString = retSBuff.toString();
			}
			
			System.out.println("Final retString["+retString+"]");
		}
		catch(Exception e)
		{
			System.out.println("SCMWebServiceDao.addTransaction()["+e.getMessage()+"]");
			throw new ITMException (e);
		}
		
		return retString;
	}
	
	private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "SCMWebServiceDao : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "SCMWebServiceDao : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
}
