package ibase.dashboard.sfa.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;
import ibase.dashboard.sfa.ejb.ImpEventsRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

public class ImportantEventServlet extends HttpServlet
{	
		
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;
	
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{	
		System.out.println("@@@@@@@@@@@@@@@@ImportantEventServlet@@@@@@@@@@@@@@@@ DOPOST @@@@@@@@@");
		
				
		ImpEventsRemote impEventsRemote = null;
		InitialContext context           = null;
		AppConnectParm appConnectParm    = new AppConnectParm();
		String dataSourceName      = "";
		String empCode             = "" ;
		HttpSession session       = null;
		JSONObject jsonObjData    = null;
		OutputStream outputStream = null;
		UserInfoBean userInfo     = null;		
		try
		{
			response.setContentType("application/xml");
			session  = request.getSession(true);
			userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");			
			if(userInfo != null)
			{
				empCode = userInfo.getEntityCode();
			}	
			dataSourceName  = request.getParameter("dataSourceName");			
			context         = new InitialContext(appConnectParm.getProperty());			
			impEventsRemote =  (ImpEventsRemote)context.lookup("ibase/ImpEvents/remote");		
			jsonObjData     = (JSONObject) impEventsRemote.getEvents(empCode,dataSourceName);			
			outputStream    = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set in ImpEventsRemote  build the Graph ="+ jsonObjData);

		}
		catch (Exception e)
		{
			System.out.println("Exception : ImpEventsRemote :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
