package ibase.dashboard.common.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.dashboard.common.hibernate.utility.HibernateUtil;


@Indexed
@Entity
@Table(name = "USERS")
@XmlRootElement(name = "UserProfile")
public class UserProfile implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name="CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String userCode;
	
	@Column(name="BIRTH_DATE")
	private Date birthDate;
	
	@Column(name="GENDER")
	private String gender;
	
	@Column(name="NAME")
	private String userName;
	
	@Transient
	private String firstName;
	
	@Transient
	private String lastName;
	
	@Column(name="EMAIL_ID")
	private String emailId;
			 
	@Column(name="MOBILE_NO")	
	private String contactNo;
	
	@Column(name="EMP_CODE")	
	private String empCode;



	public UserProfile() {
	}


	public UserProfile(String userCode, Date birthDate, String gender, String userName, String emailId,
			String contactNo,String empCode) {
		this.userCode = userCode;
		this.birthDate = birthDate;
		this.gender = gender;
		this.userName = userName;
		this.emailId = emailId;
		this.contactNo = contactNo;
		this.empCode=empCode;
	}


	public String getEmpCode() {
		return empCode;
	}


	public void setEmpCode(String empCode) {
		this.empCode = empCode;
	}


	public String getUserCode() {
		return userCode;
	}

	@XmlElement
	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}


	public Date getBirthDate() {
		return birthDate;
	}

	@XmlElement
	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}


	public String getGender() {
		return gender;
	}

	@XmlElement
	public void setGender(String gender) {
		this.gender = gender;
	}


	public String getUserName() {
		return userName;
	}

	@XmlElement
	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getFirstName() {
		return firstName;
	}

	@XmlElement
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	@XmlElement
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	public String getEmailId() {
		return emailId;
	}

	@XmlElement
	public void setEmailId(String emailId) {
		this.emailId = emailId;
	}


	public String getContactNo() {
		return contactNo;
	}

	@XmlElement
	public void setContactNo(String contactNo) {
		this.contactNo = contactNo;
	}


	@Override
	public String toString(){
		return "\n UserProfile.toString >> [" + new JSONObject(this).toString() + "]";
	}
	
}
