package ibase.dashboard.common.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;


@Indexed
@Entity
@Table(name = "LOGINTRACE")
@XmlRootElement(name = "LoginTrace")

public class LoginTrace implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	 
	   @Id
	   @Field(store = Store.YES, analyze = Analyze.NO)
	   @Column(name="USERID")
	   private String userId;
	   
	   @Column(name="LOGINTIME")
	   private Date loginTime;

	   @Column(name="LOGOUTTIME")
	   private Date logoutTime;

	   @Id
	   @Field(store = Store.YES, analyze = Analyze.NO)
	   @Column(name="SESSIONID")
	   private String sessionId;
	 
	   @Column(name="LOGIN_STATUS")
	   private String loginStatus;
	 
	   @Column(name="SESSION_DESTROY")
	   private String sessionDestroy;
	   
	   @Column(name="DEVICE_TYPE")
	   private String deviceType;

	   @Column(name="HOST_IP")
	   private String hostIp;
	   

	   @Column(name="CURRENT_GEO_POS")
	   private String currentGeoPos;
	   
	   
	   @Column(name="LOGIN_BATTERY_STAT")
	   private Integer loginBatteryStat;
	   
	   @Column(name="LOGOUT_BATTERY_STAT")
	   private Integer logoutBatteryStat;
	   
	   @Column(name="OS_NAME")
	   private String osName;
	   
	   @Column(name="OS_VERSION")
	   private String osVersion;
	   
	   @Column(name="CLIENT_APP")
	   private String clientApp;
	   
	   @Column(name="CLIENT_APP_VER")
	   private String clientAppVer;
	   
	   public LoginTrace() {
			
	   }
	   
    	public LoginTrace(String userId, Date loginTime, Date logoutTime,  String sessionId, String loginStatus,
				String sessionDestroy,String deviceType,String hostIp,String currentGeoPos,Integer loginBatteryStat,
				Integer logoutBatteryStat,String osName,String osVersion,String clientApp,String clientAppVer
				) {
			this.userId = userId;
			this.loginTime = loginTime;
			this.logoutTime = logoutTime;
			this.sessionId = sessionId;
			this.loginStatus = loginStatus;
			this.sessionDestroy = sessionDestroy;
			this.deviceType = deviceType;
			this.hostIp = hostIp;
			this.currentGeoPos = currentGeoPos;
			this.loginBatteryStat = loginBatteryStat;
			this.logoutBatteryStat=logoutBatteryStat;
			this.osName = osName;
			this.osVersion=osVersion;
			this.clientApp = clientApp;
			this.clientAppVer=clientAppVer;
		}

    	public String getUserId() {
		return userId;
	    }

		public void setUserId(String userId) {
			this.userId = userId;
		}
	
		public Date getLoginTime() {
			return loginTime;
		}
	
		public void setLoginTime(Date loginTime) {
			this.loginTime = loginTime;
		}
	
		public Date getLogoutTime() {
			return logoutTime;
		}
	
		public void setLogoutTime(Date logoutTime) {
			this.logoutTime = logoutTime;
		}
	
		public String getSessionId() {
			return sessionId;
		}
	
		public void setSessionId(String sessionId) {
			this.sessionId = sessionId;
		}
	
		public String getLoginStatus() {
			return loginStatus;
		}
	
		public void setLoginStatus(String loginStatus) {
			this.loginStatus = loginStatus;
		}
	
		public String getSessionDestroy() {
			return sessionDestroy;
		}
	
		public void setSessionDestroy(String sessionDestroy) {
			this.sessionDestroy = sessionDestroy;
		}
		public String getDeviceType() {
			return deviceType;
		}
	
		public void setDeviceType(String deviceType) {
			this.deviceType = deviceType;
		}
	
		public String getHostIp() {
			return hostIp;
		}
	
		public void setHostIp(String hostIp) {
			this.hostIp = hostIp;
		}
	
		public String getCurrentGeoPos() {
			return currentGeoPos;
		}
	
		public void setCurrentGeoPos(String currentGeoPos) {
			this.currentGeoPos = currentGeoPos;
		}
		
	    public Integer getLoginBatteryStat() {
			return loginBatteryStat;
		}

		public void setLoginBatteryStat(Integer loginBatteryStat) {
			this.loginBatteryStat = loginBatteryStat;
		}

		public Integer getLogoutBatteryStat() {
			return logoutBatteryStat;
		}

		public void setLogoutBatteryStat(Integer logoutBatteryStat) {
			this.logoutBatteryStat = logoutBatteryStat;
		}
		
	   public String getOsName() {
			return osName;
		}


		public void setOsName(String osName) {
			this.osName = osName;
		}


		public String getOsVersion() {
			return osVersion;
		}


		public void setOsVersion(String osVersion) {
			this.osVersion = osVersion;
		}


		public String getClientApp() {
			return clientApp;
		}


		public void setClientApp(String clientApp) {
			this.clientApp = clientApp;
		}


		public String getClientAppVer() {
			return clientAppVer;
		}


		public void setClientAppVer(String clientAppVer) {
			this.clientAppVer = clientAppVer;
		}

		@Override
		public String toString(){
			return "\n LoginTrace.toString >> [" + new JSONObject(this).toString() + "]";
		}
}

/*
{
	  "userId": "",
	  "userName": "",
	  "designation": "",
	  "batteryStatus": {
	    "dayStart": "",
	    "dayEnd": "",
	    "loginTime": "",
	    "logoutTime": ""
	  },
	  "activityDetail": [
	    {
	      "browserName": "",
	      "totalTime": "",
	      "hostIp": "",
	      "currentGeoPos": "",
	      "activityData": [
	        {
	          "actObjName": "",
	          "actObjDescr": "",
	          "accessStartTime": "",
	          "accessEndTime": ""
	        },
	        {
	          "actObjName": "",
	          "actObjDescr": "",
	          "accessStartTime": "",
	          "accessEndTime": ""
	        }
	      ]
	    },
	    {
	      "browserName": "",
	      "totalTime": "",
	      "hostIp": "",
	      "currentGeoPos": "",
	      "activityData": [
	        {
	          "actObjName": "",
	          "actObjDescr": "",
	          "accessStartTime": "",
	          "accessEndTime": ""
	        },
	        {
	          "actObjName": "",
	          "actObjDescr": "",
	          "accessStartTime": "",
	          "accessEndTime": ""
	        }
	      ]
	    }
	  ]
	}
*/