package ibase.dashboard.common.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.dashboard.common.hibernate.utility.HibernateUtil;


@Indexed
@Entity
@Table(name = "Employee")
@XmlRootElement(name = "employee")
public class Employee implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name="EMP_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String empCode;
	
	@Column(name="EMP_FNAME")
	private String empFname;
	
	@Column(name="EMP_LNAME")
	private String empLname;

	@Column(name="DESIGNATION")
	private String designation;
	
	@Column(name="REPORT_TO")
	private String reportTo;

	public Employee() {
	}
	
	public Employee(String empCode, String empFname, String empLname, String designation,  String reportTo
		) {
		this.empCode = empCode;
		this.empFname = empFname;
		this.empLname = empLname;
		this.designation = designation;
		this.reportTo = reportTo;

	}
	
	
	public String getEmpCode() {
		return empCode;
	}

	public void setEmpCode(String empCode) {
		this.empCode = empCode;
	}

	public String getEmpFname() {
		return empFname;
	}

	public void setEmpFname(String empFname) {
		this.empFname = empFname;
	}

	public String getEmpLname() {
		return empLname;
	}

	public void setEmpLname(String empLname) {
		this.empLname = empLname;
	}

	public String getDesignation() {
		return designation;
	}

	public void setDesignation(String designation) {
		this.designation = designation;
	}
	
	public String getReportTo() {
		return reportTo;
	}

	public void setReportTo(String reportTo) {
		this.reportTo = reportTo;
	}

	@Override
	public String toString(){
		return "\n Employee.toString >> [" + new JSONObject(this).toString() + "]";
	}
	
}
