package ibase.dashboard.metadata.servlet;
import ibase.dashboard.metadata.ejb.DashboardParentEJBRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.PopUpBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DashboardFilterServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;	
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{ 
		PopUpBean popUpBean = null;
	    String xmlString = null;
	    String[] parameters = null;
	    String keyString = null;
	    String objName = null;
	    StringTokenizer st = null;
	    HttpSession session = request.getSession(true);
	    String transDB ="";	    
	    DashboardParentEJBRemote dashboardParentEJBRemote = null;
	    try
	    {
	        String fieldName       = request.getParameter("FIELDNAME");
	        UserInfoBean userInfo  = (UserInfoBean) session.getAttribute("USER_INFO");
	        fieldName              = fieldName.trim();	
	        objName                = request.getParameter("OBJ_NAME");
	        transDB                = userInfo.getTransDB();
	        //keyString = request.getParameter("KEYSTRING");
	       
	        //Add new code By birendra  on dated 23/6/2015  
	        InitialContext ctx       = getInitialContext();
	        dashboardParentEJBRemote = (DashboardParentEJBRemote)ctx.lookup("ibase/DashboardParentEJB/remote");
		    keyString                = dashboardParentEJBRemote.getKeyString("W_" + objName, fieldName, transDB);
	       	        
	        //Add new code By Birendra  on dated 23/6/2015   
	        int pos = fieldName.lastIndexOf(".");
	
	        fieldName = fieldName.substring(pos + 1, fieldName.length());
	        //Add new code By Birendra Pandey on dated 27/06/2014       
	       
	        if (objName != null && (objName != (String) session.getAttribute("OBJ_NAME")))
	        {
	            objName = request.getParameter("OBJ_NAME");
	        } else
	        {
	            objName = (String) session.getAttribute("OBJ_NAME");
	        }
	        //END new code By Birendra Pandey on dated 27/06/2014   
	   
	        objName = objName.trim();
	
	        System.out.println("objName=====" + objName + "  fieldName=====" + fieldName + "  keyString is =====" + keyString);
	
	        if (keyString != null && keyString.trim().length()!=0)
	        {
	            keyString = keyString.substring(1).trim();
	            st = new StringTokenizer(keyString, ":");
	        }
	        if (st != null && st.countTokens() > 1)
	        {
	            parameters = new String[st.countTokens()];
	            int ctr = 0;
	            boolean flag = false;
	            while (st.hasMoreTokens())
	            {
	                String curToken = st.nextToken();
	                if (curToken.indexOf(".") != -1)
	                {
	                    curToken = curToken.substring(curToken.indexOf(".") + 1);
	                }
	                flag = true;	                
	                curToken = (curToken.indexOf(",") != -1) ? curToken.substring(0, curToken.indexOf(",")) : curToken;
	                parameters[ctr] = request.getParameter(curToken);
	                ctr++;
	
	            }
	        } else
	        {
	            parameters = new String[1];
	            if ((keyString != null) && (keyString.indexOf(".") != -1))
	            {
	                keyString = keyString.substring(keyString.indexOf(".") + 1);
	                parameters[0] = request.getParameter(keyString);
	            } else
	            {
	                parameters[0] = request.getParameter(keyString);
	            }
	        }
	        // change the code by Birendra Pandey used the concept of multitendency
	        popUpBean = new PopUpBean(userInfo);
	        popUpBean.setObjName(objName);
	        popUpBean.setUserInfoBean(userInfo);	
	        xmlString = popUpBean.getPopUpXML(fieldName, parameters);
	
	        if (xmlString == null)
	        {
	            xmlString = "<Root> </Root>";
	        }
	        System.out.println("Pop help xml string==" + xmlString);
	        OutputStream outputStreampop = response.getOutputStream();
	        outputStreampop.write(xmlString.toString().getBytes());
	        outputStreampop.flush();
	        outputStreampop.close();
	    } catch (Exception e)
	    {
	        System.out.println("Exception : SalesPerfrmncFilterServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
	        try
	        {
	            throw new ITMException(e);
	        } catch (ITMException e1)
	        {
	            e1.printStackTrace();
	        }
	    }
    }

//Add new method for get sql input string from pophel table by Birendra Pandey on dated:
	

	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :RequestHandlerServlet :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :RequestHandlerServlet :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	
	
	
	
	//
	/*public String getKeyString(String modName, String fieldName, UserInfoBean userInfo)
    {
        ConnDriver connDriver = new ConnDriver();
        Statement statement = null;
        ResultSet resultSet = null;
        String keyString = "";
        Connection connection = null;
        String transDB = "";
        try
        {
           transDB          = userInfo.getTransDB();
           dashboardUtility = new DashboardUtility();
           if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
            {
                connection = connDriver.getConnectDB(transDB);
            }
           else
            {
                connection = connDriver.getConnectDB("DriverITM");
            }
            statement = connection.createStatement();
            String query = "SELECT SQL_INPUT FROM POPHELP WHERE MOD_NAME ='" + modName + "' AND FIELD_NAME = '" + fieldName.toUpperCase() + "'";
           
            System.out.println("modName is ="+modName+ "  fieldName is= "+fieldName + " and query " +query);
           
            resultSet = statement.executeQuery(query);
            if (resultSet.next())
            {
                keyString = dashboardUtility.checkNull(resultSet.getString("SQL_INPUT"));
            }
        } catch (Exception e)
        {
            e.printStackTrace();
        } finally
        {
            try
            {
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                connection.close();
                connection = null;
            } catch (Exception ex)
            {
                System.out.println("Finally Exception : DashboardFilterServlet: getKeyString()" + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return keyString;
    }
*/
	
	
	
	
//end the 	getKeyString method
	
	
}