package ibase.webitm.webService.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

import javax.ejb.Stateless;

@Stateless
public class ExtServiceEJB implements ExtServiceRemote,ExtServiceLocal 
{
	@Override
	public HashMap<String, String> getEmployeeDetails(UserInfoBean userInfoBean)  
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String, String> resultDtlMap = new HashMap<String, String>();
		try 
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			String transDB = genericUtility.checkNull(userInfoBean.getTransDB());
			ConnDriver connDriver = new ConnDriver();
			if( transDB.length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			else
			{
				conn = connDriver.getConnectDB( "DriverITM" );
			}
			connDriver = null;
			String sql = " SELECT (E1.EMP_FNAME || ' ' || E1.EMP_MNAME || ' ' || E1.EMP_LNAME) EMP_NAME, E1.GRADE, E1.CADRE, E1.DESIGNATION, E1.REPORT_TO, " +
					" (E2.EMP_FNAME || ' ' || E2.EMP_MNAME || ' ' || E2.EMP_LNAME) REPORT_TO_NAME, E1.EMAIL_ID_OFF, E1.EMP_SITE, E1.EMP_CODE__HOD, " +
					" (E3.EMP_FNAME || ' ' || E3.EMP_MNAME || ' ' || E3.EMP_LNAME) HOD_NAME, E2.EMAIL_ID_OFF REPORT_TO_EMAIL,  E3.EMAIL_ID_OFF HOD_EMAIL, E1.CCTR_CODE__SAL, " +
					" E1.PAY_SITE, E1.WORK_SITE, E1.ALTER_CODE FROM EMPLOYEE E1 " +
					" LEFT OUTER JOIN EMPLOYEE E2 ON E2.EMP_CODE = E1.REPORT_TO " +
					" LEFT OUTER JOIN EMPLOYEE E3 ON E3.EMP_CODE = E1.EMP_CODE__HOD " +
					" WHERE E1.EMP_CODE = ? ";
         
			pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, userInfoBean.getEmpCode());
            rs = pstmt.executeQuery();
            
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            
            while( rs.next() )
            {
             	for( int colNo = 1; colNo <= colCount; colNo++ )
            	{
            		String colName = rsmd.getColumnName(colNo);
            		colName = colName.toUpperCase();
            		colName = new E12GenericUtility().initCap( colName, "_" );
            		
            		String colValues = genericUtility.checkNull(rs.getString( colNo ));
            		resultDtlMap.put( colName, colValues );
            	}
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
		}
		catch (Exception e) 
		{
			resultDtlMap = null;
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				System.out.println( "Exception :getEmployeeDtl " + e.getMessage() );
				e.printStackTrace();
			}
		}
		System.out.println("resultDtlJson in EJB - ["+ resultDtlMap +"]");
		return resultDtlMap;
	}

	//Added by Prasad on 11/05/17 [for creating log of accessing web service] START
	@Override
	public String createExtServiceLog(String tokenId, String action, String params, String responseType, String response, String requestedTerm, String requestedUser, String hostName, String hostIP, UserInfoBean userInfo) throws ITMException 
	{
		String returnString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		try 
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			System.out.println("In createExtServiceLog - \ntokenId - ["+ tokenId +"], \naction - ["+ action +"], \nparams - ["+ params +"]");
			ConnDriver connDriver = new ConnDriver();
			String transDB = "";
			if ( userInfo != null )
			{
				transDB = genericUtility.checkNull( userInfo.getTransDB() );
			}
            if( transDB.length() > 0 )
            {
                conn = connDriver.getConnectDB( transDB );
            }
            else
            {
                conn = connDriver.getConnectDB( "DriverITM" );
            }
            conn.setAutoCommit(false);
			connDriver = null;
            
			String tranId = "";
			String seqQuery = "SELECT EXT_SERVICE_LOG_SEQ.NEXTVAL FROM DUAL";
			pstmt = conn.prepareStatement( seqQuery );
			ResultSet rs = pstmt.executeQuery();
			if( rs.next() )
			{
				tranId = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			String sql = "";
			int insertCnt = 0;
			if( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM, HOST_NAME, HOST_IP) "
						+ " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				
				byte[] paramsArray = (params != null ? params.getBytes() : null );
				ByteArrayInputStream paramsByteArray = (paramsArray != null ? new ByteArrayInputStream( paramsArray ) : null );
				
				byte[] responseArray = (response != null ? response.getBytes() : null );
				ByteArrayInputStream responseByteArray = (responseArray != null ? new ByteArrayInputStream( responseArray ) : null );
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, tokenId);
				pstmt.setString(3, action);
				if(paramsByteArray != null )
				{
					pstmt.setBinaryStream(4, paramsByteArray, paramsByteArray.available());
				}
				else
				{
					pstmt.setBinaryStream(4, null, 0);
				}
				pstmt.setString(5, responseType);
				if(responseByteArray != null )
				{
					pstmt.setBinaryStream(6, responseByteArray, responseByteArray.available());
				}
				else
				{
					pstmt.setBinaryStream(6, null, 0);
				}
				pstmt.setTimestamp(7, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(8, requestedUser );
				pstmt.setString(9, requestedTerm );
				pstmt.setString(10, hostName );
				pstmt.setString(11, hostIP );
				insertCnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			}
			else
			{
				sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM, HOST_NAME, HOST_IP) "
						+ " VALUES (?, ?, ?, EMPTY_BLOB(), ?, EMPTY_BLOB(), ?, ?, ?, ?, ?)";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, tokenId);
				pstmt.setString(3, action);
				pstmt.setString(4, responseType);
				pstmt.setTimestamp(5, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(6, requestedUser );
				pstmt.setString(7, requestedTerm );
				pstmt.setString(8, hostName );
				pstmt.setString(9, hostIP );
				insertCnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				
				boolean updateFlag = false;
				if ( insertCnt > 0 )
				{
					pstmt = conn.prepareStatement("SELECT PARAM, RESPONSE FROM EXT_SERVICE_LOG WHERE TRAN_ID = ? FOR UPDATE");
					pstmt.setString( 1, tranId );
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						updateFlag = true;
						Blob mapBlob = rs.getBlob(1);
						OutputStream blobOutputStream = ((oracle.sql.BLOB)mapBlob).getBinaryOutputStream();
						params = genericUtility.checkNull( params );
						blobOutputStream.write( params.getBytes() );
						blobOutputStream.close();
						blobOutputStream = null;
						mapBlob = null;
						
						mapBlob = rs.getBlob(2);
						blobOutputStream = ((oracle.sql.BLOB)mapBlob).getBinaryOutputStream();
						response = genericUtility.checkNull( response );
						blobOutputStream.write( response.getBytes() );
						blobOutputStream.close();
						blobOutputStream = null;
						mapBlob = null;
					}
					pstmt.close();
					pstmt = null;
					rs.close();
					rs = null;
				}
				System.out.println( "updateFlag - "+ updateFlag );
			}
			System.out.println("<..........ROW INSERTED.............> [" + insertCnt + "]");
			
			if ( conn != null )
			{
				conn.commit();
				conn.close();
				conn = null;
			}
			returnString = "<ROOT><RESULT>Success</RESULT></ROOT>";
		}
		catch (SQLException e) 
		{
			returnString = "<ROOT><RESULT>"+ e.getMessage() +"</RESULT></ROOT>";
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			returnString = "<ROOT><RESULT>"+ e.getMessage() +"</RESULT></ROOT>";
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				System.out.println( "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
		System.out.println("returnString - ["+ returnString +"]");
		
		return returnString;
	}
	//Added by Prasad on 11/05/17 [for creating log of accessing web service] END
}