package proteus.ecm.service;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.cache.dao.SystemCache;
import proteus.ecm.hibernate.bean.Country;
import proteus.ecm.hibernate.bean.ECMParm;
import proteus.ecm.hibernate.bean.SiteItem;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.bean.State;
import proteus.ecm.hibernate.dao.SystemMasterDAO;
import proteus.ecm.schedule.StartUp;

@Path("/sys")
public class SystemService 
{
    @Context
    HttpServletRequest request; // The proxy of Request will be injected into this singleton

    @Context
    HttpServletResponse response; // The proxy of Request will be injected into this singleton

    private SystemMasterDAO masterDAO = new SystemMasterDAO();
    private SystemCache systemCache = new SystemCache();
    
	@GET
	@Path("/site")
	@Produces({ "application/xml", "application/json" })
	public List<SiteMaster> getAllSites() 
	{
		System.out.println("\n getCachedSites");
		List<SiteMaster> allSites = systemCache.getCachedSites(CacheManager.SYSTEM_CACHE_NAME);
		if( allSites == null )
		{
			System.out.println("\n Populate All Sites");
			masterDAO.fetchAllSites(CacheManager.SYSTEM_CACHE_NAME);
			allSites = systemCache.getCachedSites(CacheManager.SYSTEM_CACHE_NAME);
		}
		return allSites;
	}

    
	@GET
	@Path("/site/{siteCode}")
	@Produces({ "application/xml", "application/json" })
	public Response getSite(@PathParam("siteCode") String siteCode) 
	{
		System.out.println("\n getCachedSite");
		
		StartUp	startUp = new StartUp();
		startUp.loadOnStartUp(siteCode);
		
		SiteMaster site = systemCache.getCachedSite(siteCode, CacheManager.SYSTEM_CACHE_NAME);
		if( site == null )
		{
			System.out.println("\n Populate Site");
			//masterDAO.fetchSite(siteCode);
			masterDAO.fetchAllSites(CacheManager.SYSTEM_CACHE_NAME);
			site = systemCache.getCachedSite(siteCode, CacheManager.SYSTEM_CACHE_NAME);
		}
		//		setSiteInfo(siteCode);
		return Response.status(200).entity( new JSONObject(site).toString() ).build();
	}

	@GET
	@Path("/siteitems/{siteCode}")
	@Produces({ "application/xml", "application/json" })
	public List<SiteItem> getSiteItems(@PathParam("siteCode") String siteCode) 
	{
		String cacheName = "CACHE_" + siteCode;
		System.out.println("\n getCachedSiteItems");
		List<SiteItem> siteItems = systemCache.getCachedSiteItems(siteCode, cacheName);
		if( siteItems == null )
		{
			System.out.println("\n Populate All SitesItems");
			masterDAO.fetchSiteItems(siteCode, cacheName);
			siteItems = systemCache.getCachedSiteItems(siteCode, cacheName);
		}
		return siteItems;
	}
	
	private void setSiteInfo(String siteCode) 
	{
		SiteMaster site = systemCache.getCachedSite(siteCode, CacheManager.SYSTEM_CACHE_NAME);
		if( site != null )
		{
			HttpSession session = request.getSession();
			System.out.println("Setting siteCode[" + site.getSiteCode() + "] siteTranDB[" + site.getTranDB() + "]"); 
			session.setAttribute("CURRENT_SITE", site);
			String siteTranDB = site.getTranDB();
			if( siteTranDB != null && siteTranDB.trim().length() > 0 )
			{
				session.setAttribute("SITE_TRANDB", siteTranDB);
			}
		}
		else
		{
			System.out.println("INVALID_SITE !");
		}
	}
	
	@GET
	@Path("/ecmparm/{param}")
	@Produces({ "application/xml", "application/json" })
	public Response getEcmParms(@PathParam("param") String param) 
	{
		System.out.println("\n getEcmParms[" + param + "]");
		if( "auth".equalsIgnoreCase(param) )
		{
			HashMap<String,ECMParm> ecmParamData = masterDAO.fetchEcmParms(param, false);
			return auth(ecmParamData);
		}
		else
		{
			HashMap<String,ECMParm> ecmParamData = masterDAO.fetchEcmParms(param, true);
			return Response.status(200).entity( ecmParamData.get(param) ).build();
		}
	}
	
	private Response auth(HashMap<String,ECMParm> ecmParamData)
	{
		try
		{
			StringBuffer sb = new StringBuffer();
			//Call Login Service /ibase/rest/E12ExtService/login?USER_CODE=BASE&PASSWORD=BASE&IS_PWD_ENCRYPT=false&DATA_FORMAT=JSON
			System.out.println("auth_user_name [" + ecmParamData.get("auth_user_name") + "]");
			System.out.println("auth_user_pwd [" + ecmParamData.get("auth_user_pwd") + "]");
			
			sb.append( "USER_CODE=" ).append( ecmParamData.get("auth_user_name").getVarValue() );
			sb.append( "&PASSWORD=" ).append( ecmParamData.get("auth_user_pwd").getVarValue() );
			sb.append( "&IS_PWD_ENCRYPT=false" );
			sb.append( "&DATA_FORMAT=JSON" );

			if( !request.isSecure() )
			sb.append( "&TEST=" ).append( "ON" );
			 
			//response.sendRedirect("/ibase/rest/E12ExtService/login?"+sb.toString() );
			//URI location = new URI("/ibase/rest/E12ExtService/login?"+sb.toString() );
			
			StringBuffer requestUrl = this.request.getRequestURL();
		      //String Url = requestUrl.substring(0, requestUrl.indexOf("/ecm"));
		      String Url = requestUrl.substring(0, requestUrl.indexOf("/ibase/ecm"));
		      System.out.println("Request URL After: [" + Url);
		      
		      String strUrl = "/ibase/rest/E12ExtService/login?" + sb.toString();
		      //URL url = new URL(Url + strUrl);
		      
		      //String xmlResponse = IOUtils.toString(url);
		      System.out.println("auth Response \n");
		      
		      response.sendRedirect(Url + strUrl);
		      
		      return Response.status(200).entity( "Success" ).build();
		}
		catch(Exception se)
		{
			System.out.println("Auth Exception: " + se.getMessage());
			se.printStackTrace(System.out);
			return Response.status(200).entity( "Auth Exception: " + se.getMessage() ).build();
		}	
	}
	
	// "/ibase/rest/E12ExtService/login?USER_CODE=<username>&PASSWORD=<password>&IS_PWD_ENCRYPT=<true/false>&DATA_FORMAT=JSON"
	// "/ibase/rest/E12ExtService/logout?USER_CODE=<username>&TOKEN_ID=<tokenId>&DATA_FORMAT=JSON"
	// "/ibase/rest/E12ExtService/forgot_password?USER_CODE=<username>&DATA_FORMAT=JSON"
		
	// "/ibase/rest/ExtAuthAppService/extauthapi?USER_CODE=<username>&PASSWORD=<password>&IS_PWD_ENCRYPT=<true/false>&APP_ID=APP001"
	// "/ibase/rest/ExtAuthAppService/extlogout?JWT=<jwtToken>&APP_ID=APP001"
	
	@GET
	@Path("/auth/login")
	@Produces({ "application/xml", "application/json" })
	public Response authenticateUser(@QueryParam("username") String userCode, @QueryParam("password") String password ) 
	{
		try
		{
			System.out.println("\n authenticateUser userCode[" + userCode + "]password[" + password + "]");
			StringBuffer sb = new StringBuffer();
			sb.append( "USER_CODE=" ).append( userCode );
			sb.append( "&PASSWORD=" ).append( password );
			sb.append( "&IS_PWD_ENCRYPT=true");
			sb.append( "&DATA_FORMAT=JSON" );
			
			if( !request.isSecure() )
			sb.append( "&TEST=" ).append( "ON" );
			 
			//response.sendRedirect("/ibase/rest/E12ExtService/login?"+sb.toString() );
			//URI location = new URI("/ibase/rest/E12ExtService/login?"+sb.toString() );
			
			StringBuffer requestUrl = request.getRequestURL();
		    //String Url = requestUrl.substring(0, requestUrl.indexOf("/ecm"));
		    String Url = requestUrl.substring(0, requestUrl.indexOf("/ibase/ecm"));
			System.out.println("Request URL After: ["+requestUrl+"]\n["+Url+"]");
			
			String strUrl ="/ibase/rest/E12ExtService/login?"+sb.toString();
			URL url = new URL(Url+strUrl);
			
			//String xmlResponse = org.apache.commons.io.IOUtils.toString(url);		
			String xmlResponse = "Success";
			System.out.println("Auth Response \n" +xmlResponse);
			
			response.sendRedirect(Url + strUrl);
			System.out.println("Inside Auth:::"+ request.getSession().getId());
	        JSONObject responseData = new JSONObject(xmlResponse);
	        System.out.println("\n\n JSON Format \n"+responseData);
			
	        String status = (String)responseData.getJSONObject("Response").get("status");
	        if("success".equals(status))
	        {
	        	request.getSession().setAttribute("AUTH_USER", userCode);
	        }
	        
			return Response.status(200).entity( xmlResponse ).build();
	    }
		catch(Exception se)
		{
			System.out.println("Auth Exception: " + se.getMessage());
			se.printStackTrace(System.out);
			return Response.status(200).entity( "Auth Exception: " + se.getMessage() ).build();
		}	
	}
	
	@GET
	@Path("/auth/logout")
	@Produces({ "application/xml", "application/json" })
	public Response logoutUser(@QueryParam("username") String userCode, @QueryParam("tokenid") String tokenid ) 
	{
		try
		{
			System.out.println("\n authenticateUser userCode[" + userCode + "]tokenid[" + tokenid + "]");
			StringBuffer sb = new StringBuffer();
			sb.append( "USER_CODE=" ).append( userCode );
			sb.append( "&TOKEN_ID=" ).append( tokenid );
			sb.append( "&DATA_FORMAT=JSON" );

			if( !request.isSecure() )
			sb.append( "&TEST=" ).append( "ON" );
			 
			 
			//response.sendRedirect("/ibase/rest/E12ExtService/login?"+sb.toString() );
			//URI location = new URI("/ibase/rest/E12ExtService/logout?"+sb.toString() );
			StringBuffer requestUrl = this.request.getRequestURL();
		      //String Url = requestUrl.substring(0, requestUrl.indexOf("/ecm"));
		      String Url = requestUrl.substring(0, requestUrl.indexOf("/ibase/ecm"));
		      System.out.println("Request URL After: [" + Url);
		      
		      String strUrl = "/ibase/rest/E12ExtService/logout?" + sb.toString();
		      //URL url = new URL(Url + strUrl);
		      
		      //String xmlResponse = IOUtils.toString(url);
		      System.out.println("logoutUser Response \n");
		      
		      request.getSession().removeAttribute("AUTH_USER");
		      response.sendRedirect(Url + strUrl);
		      return Response.status(200).entity( "Success" ).build();
	    }
		catch(Exception se)
		{
			System.out.println("Auth Exception: " + se.getMessage());
			se.printStackTrace(System.out);
			return Response.status(200).entity( "Auth Exception: " + se.getMessage() ).build();
		}	
	}

	  @GET
	  @Path("/auth/forgot")
	  @Produces({"application/xml", "application/json"})
	  public Response forgotPassword(@QueryParam("username") String userCode)
	  {
	    try
	    {
	      System.out.println("\n forgotPassword userCode[" + userCode + "]");
	      StringBuffer sb = new StringBuffer();
	      sb.append("USER_CODE=").append(userCode);
	      sb.append("&GENERATE_PASS=false");
	      sb.append("&DATA_FORMAT=JSON");
	      
	      if( !request.isSecure() )
	      sb.append( "&TEST=" ).append( "ON" );
			 
	      StringBuffer requestUrl = this.request.getRequestURL();
	      //String Url = requestUrl.substring(0, requestUrl.indexOf("/ecm"));
	      String Url = requestUrl.substring(0, requestUrl.indexOf("/ibase/ecm"));
	      System.out.println("Request URL After: [" + Url);
	      
	      String strUrl = "/ibase/rest/E12ExtService/forgot_password?" + sb.toString();
	      URL url = new URL(Url + strUrl);
	      
	      String xmlResponse = IOUtils.toString(url);
	      System.out.println("forgotPassword Response \n" + xmlResponse);
	      
	      JSONObject responseData = new JSONObject(xmlResponse);
	      System.out.println("\n\n JSON Format \n" + responseData);
	      
	      String status = (String)responseData.getJSONObject("Response").get("status");
	      if ("success".equalsIgnoreCase(status))
	      {
	        String varCode = (String)responseData.getJSONObject("Response").get("results");
	        this.systemCache.storeVerificationCode(userCode, varCode);
	        System.out.println("forgotPassword After: userCode[" + userCode + "] varCode[" + varCode + "]");
	        xmlResponse = getResponseMessage("Verification code sent to your Email-ID", "Success");
	      }
	      System.out.println("\n\n forgotPassword status ["+status+"]\n xmlResponse >> " + xmlResponse );
	      return Response.status(200).entity(xmlResponse).build();
	    }
	    catch (Exception se)
	    {
	      System.out.println("Auth Exception: " + se.getMessage());
	      se.printStackTrace(System.out);
	      return Response.status(200).entity("Auth Exception: " + se.getMessage()).build();
	    }
	  }
	  
	  @GET
	  @Path("/auth/verify")
	  @Produces({"application/xml", "application/json"})
	  public Response verifyCode(@QueryParam("username") String userCode, @QueryParam("varcode") String varCode)
	  {
	    try
	    {
	      String cacheVarCode = this.systemCache.getVerificationCode(userCode);
	      System.out.println("\n verifyCode userCode[" + userCode + "]varCode[" + varCode + "]cacheVarCode[" + cacheVarCode + "]");
	      String responseString = "{}";
	      if (cacheVarCode == null) {
	    	  responseString = getResponseMessage("Verification code is expired. Try again !", "error");
	      } 
	      else if ( varCode != null && !varCode.equalsIgnoreCase(cacheVarCode) ) 
	      {
		      responseString = getResponseMessage("Verification code does not match", "error");
	      } 
	      else 
	      {
	    	  responseString = getResponseMessage("Verification code is match", "Success");
	      }
	      return Response.status(200).entity(responseString).build();
	    }
	    catch (Exception se)
	    {
	      System.out.println("Auth Exception: " + se.getMessage());
	      se.printStackTrace(System.out);
	      return Response.status(200).entity("Auth Exception: " + se.getMessage()).build();
	    }
	  }
	  
	  @GET
	  @Path("/auth/changePassword")
	  @Produces({"application/xml", "application/json"})
	  public Response changePassword(@QueryParam("username") String userCode, @QueryParam("npassword") String newpassword, 
			   						 @QueryParam("cpassword") String oldPassword, @QueryParam("tokenid") String tokenId)
	  {
		  try
		    {
		      System.out.println("\n changePassword userCode[" + userCode + "]newpassword[" + newpassword + "]oldPassword[" + oldPassword + "]tokenId[" + tokenId + "]");
		      StringBuffer sb = new StringBuffer();
		      sb.append("USER_CODE=").append(userCode);
		      sb.append("&NEW_PASS="+ newpassword);
		      sb.append("&DATA_FORMAT=JSON");
		      
		      if( !request.isSecure() )
			  sb.append( "&TEST=" ).append( "ON" );
				 
			  
		      StringBuffer requestUrl = this.request.getRequestURL();
		      //String Url = requestUrl.substring(0, requestUrl.indexOf("/ecm"));
		      String Url = requestUrl.substring(0, requestUrl.indexOf("/ibase/ecm"));
		      System.out.println("Request URL After: [" + Url);
		      
		      String strUrl = "/ibase/rest/E12ExtService/changePassword?" + sb.toString();
		      if(tokenId != null)
		      {
			      sb.append("&OLD_PASS="+ oldPassword);
			      sb.append("&TOKEN_ID="+ tokenId);
		    	  strUrl = "/ibase/rest/E12ExtService/change_password?" + sb.toString();
		      }
		      
		      URL url = new URL(Url + strUrl);
		      
		      String xmlResponse = IOUtils.toString(url);
		      System.out.println("changePassword Response \n" + xmlResponse);
		      
		      JSONObject responseData = new JSONObject(xmlResponse);
		      System.out.println("\n\n JSON Format \n" + responseData);
		      
		      String status = (String)responseData.getJSONObject("Response").get("status");
		      if ("success".equalsIgnoreCase(status))
		      {
		      }
		      System.out.println("\n\n changePassword status ["+status+"]\n xmlResponse >> " + xmlResponse );
		      return Response.status(200).entity(xmlResponse).build();
		    }
		    catch (Exception se)
		    {
		      System.out.println("Auth Exception: " + se.getMessage());
		      se.printStackTrace(System.out);
		      return Response.status(200).entity("Auth Exception: " + se.getMessage()).build();
		    }
	  }
	  
	     @GET
	    @Path("/state/{descr}")
	    @Produces({"application/xml", "application/json"})
	    public List<State> getState(@PathParam("descr") String descr) {
	    	 System.out.println("\n getState >>" + descr);
	       List states = this.systemCache.getCachedStates(CacheManager.SYSTEM_CACHE_NAME, descr);
	       if (states == null)
	      {
	         System.out.println("\n Populate All states");
	         this.masterDAO.fetchStates(CacheManager.SYSTEM_CACHE_NAME);
	         states = this.systemCache.getCachedStates(CacheManager.SYSTEM_CACHE_NAME, descr);
	      }
	     System.out.println("\n getState >>" + states);
	      return states; }
	  
	    @GET
	    @Path("/country/{descr}")
	    @Produces({"application/xml", "application/json"})
	    public List<Country> getCountry(@PathParam("descr") String descr) {
	      System.out.println("\n getCountry >>" + descr);
	      List countries = this.systemCache.getCachedCountries(CacheManager.SYSTEM_CACHE_NAME, descr);
	      if (countries == null)
	      {
	        System.out.println("\n Populate All countries");
	        this.masterDAO.fetchCountries(CacheManager.SYSTEM_CACHE_NAME);
	        countries = this.systemCache.getCachedCountries(CacheManager.SYSTEM_CACHE_NAME, descr);
	      }
	      return countries;
	    }

	  
	  
	  private String getResponseMessage(String successResponse, String status)
	  {
	    JSONObject responseJson = new JSONObject();
	    JSONObject respMessage = new JSONObject();
	    try
	    {
	      respMessage.put("results", successResponse);
	      respMessage.put("status", status);
	      responseJson.put("Response", respMessage);
	    }
	    catch (JSONException e)
	    {
	      e.printStackTrace();
	    }
	    return responseJson.toString();
	  }
	  
	  private String getCacheName(String siteCode) 
	  {
		  return "CACHE_" + siteCode;
	  }
}
