package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "SITE")
@XmlRootElement(name = "Site")
public class SiteMaster implements java.io.Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "SITE_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String siteCode;
	
	@Column(name = "ENTERPRISE")
	private String enterPrise;

	@Column(name = "DESCR")
	private String descr;

	@Column(name = "SH_DESCR")
	private String shDescr;

	@Column(name = "ABBRV_DESCR")
	private String abbrvDescr;

	@Column(name = "STATE_CODE")
	private String stateCode;

	@Column(name = "STAN_CODE")
	private String stanCode;

	@Column(name = "LOCALE")
	private String locale;

	@Column(name = "TRANS_DB")
	private String tranDB;

	
	public String getSiteCode() {
		return siteCode;
	}
	
	public String getEnterPrise() {
		return enterPrise;
	}

	public String getDescr() {
		return descr;
	}

	public String getShDescr() {
		return shDescr;
	}

	public String getAbbrvDescr() {
		return abbrvDescr;
	}

	public String getStateCode() {
		return stateCode;
	}

	public String getStanCode() {
		return stanCode;
	}

	public String getLocale() {
		return locale;
	}

	public String getTranDB() {
		return tranDB;
	}

	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}
	
	public void setEnterPrise(String enterPrise) {
		this.enterPrise = enterPrise;
	}


	public void setDescr(String descr) {
		this.descr = descr;
	}

	public void setShDescr(String shDescr) {
		this.shDescr = shDescr;
	}

	public void setAbbrvDescr(String abbrvDescr) {
		this.abbrvDescr = abbrvDescr;
	}

	public void setStateCode(String stateCode) {
		this.stateCode = stateCode;
	}

	public void setStanCode(String stanCode) {
		this.stanCode = stanCode;
	}

	public void setLocale(String locale) {
		this.locale = locale;
	}

	public void setTranDB(String tranDB) {
		this.tranDB = tranDB;
	}

	@Override
	public String toString(){
		return "\n SiteMaster.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
