package proteus.ecm.hibernate.bean;

import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;


@Indexed
@Entity
@Table(name = "ECM_ORDER")
@XmlRootElement(name = "Order")
public class ECMOrder implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name="EORDER_NO")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String orderNo;
	
	@Column(name="USER_ID")
	private String userId;
	
	@Column(name="ECM_SITE")
	private String ecmSite;
	
	@Column(name="CURR_CODE")
	private String currCode;
	
	@Column(name="EXCH_RATE")
	private int exchRate;
			 
	@Column(name="ORDER_DATE")
	private Date orderDate;
	 
	@Column(name="ORDER_STAT")	
	private String orderStat;
	
	@Column(name="STAT_DATE")
	private Date statDate;
	
	@Column(name="REMARKS")
	private String remark;
	
	@Column(name="DLV_ADDRESS")
	private String divAddress;
	
	@Column(name="BILL_ADDRESS")
	private String billAddress;
	
	@Column(name="AMOUNT")
	private int amount;
	
	
	@Column(name="TAX_AMT")
	private int taxAmt;
	
	@Column(name="DISC_AMT")
	private int discAmt;
	
	@Column(name="PROMO_AMT")
	private int promoAmt;
	
	@Column(name="NET_AMT")
	private int netAmt;
	
	@Column(name="WF_STAT")
	private String wfStat;
	
	@Column(name="WF_STAT_DATE")
	private Date wfStatDate;
	
	@Column(name="CHG_DATE")
	private Date chgDATE;
	
	@Column(name="CHG_USER")
	private String chgUser;
	
	@Column(name="CHG_TERM")
	private String chgTerm;
	
	@Column(name="ECM_TYPE")
	private String ecmType;
	
	@OneToMany(mappedBy="eorderNo", cascade = CascadeType.ALL, fetch = FetchType.LAZY, targetEntity= ECMOrderDet.class)
	private List<ECMOrderDet> ecmOrderDets;
	
	public ECMOrder() {
		
	}

	public ECMOrder(String orderNo, String userId, String ecmSite, String currCode, int exchRate , Date orderDate,
			        String remark, String divAddress, String billAddress, int amount,int taxAmt, int discAmt,int promoAmt,
			        int netAmt, String wfStat, Date wfStatDate, Date chgDATE, String chgUser,String chgTerm, String ecmType) {
		this.orderNo = orderNo;
		this.userId = userId;
		this.ecmSite = ecmSite;
		this.currCode = currCode;
		this.exchRate = exchRate;
		this.orderDate = orderDate;
		this.remark = remark;
		this.divAddress = divAddress;
		this.billAddress = billAddress;
		this.amount = amount;
		this.taxAmt = taxAmt;
		this.discAmt = discAmt;
		this.promoAmt = promoAmt;
		this.netAmt = netAmt;
		this.wfStat = wfStat;
		this.wfStatDate = wfStatDate;
		this.chgDATE = chgDATE;
		this.chgUser = chgUser;
		this.chgTerm = chgTerm;
		this.ecmType=ecmType;

	}

	public List<ECMOrderDet> getEcmOrderDets() {
		return ecmOrderDets;
	}

	public void setEcmOrderDets(List<ECMOrderDet> ecmOrderDets) {
		this.ecmOrderDets = ecmOrderDets;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getEcmSite() {
		return ecmSite;
	}

	public void setEcmSite(String ecmSite) {
		this.ecmSite = ecmSite;
	}

	public String getCurrCode() {
		return currCode;
	}

	public void setCurrCode(String currCode) {
		this.currCode = currCode;
	}

	public int getExchRate() {
		return exchRate;
	}

	public void setExchRate(int exchRate) {
		this.exchRate = exchRate;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public String getOrderStat() {
		return orderStat;
	}

	public void setOrderStat(String orderStat) {
		this.orderStat = orderStat;
	}

	public Date getStatDate() {
		return statDate;
	}

	public void setStatDate(Date statDate) {
		this.statDate = statDate;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getDivAddress() {
		return divAddress;
	}

	public void setDivAddress(String divAddress) {
		this.divAddress = divAddress;
	}

	public String getBillAddress() {
		return billAddress;
	}

	public void setBillAddress(String billAddress) {
		this.billAddress = billAddress;
	}

	public int getAmount() {
		return amount;
	}

	public void setAmount(int amount) {
		this.amount = amount;
	}

	public int getTaxAmt() {
		return taxAmt;
	}

	public void setTaxAmt(int taxAmt) {
		this.taxAmt = taxAmt;
	}

	public int getDiscAmt() {
		return discAmt;
	}

	public void setDiscAmt(int discAmt) {
		this.discAmt = discAmt;
	}

	public int getPromoAmt() {
		return promoAmt;
	}

	public void setPromoAmt(int promoAmt) {
		this.promoAmt = promoAmt;
	}

	public int getNetAmt() {
		return netAmt;
	}

	public void setNetAmt(int netAmt) {
		this.netAmt = netAmt;
	}

	public String getWfStat() {
		return wfStat;
	}

	public void setWfStat(String wfStat) {
		this.wfStat = wfStat;
	}

	public Date getWfStatDate() {
		return wfStatDate;
	}

	public void setWfStatDate(Date wfStatDate) {
		this.wfStatDate = wfStatDate;
	}

	public Date getChgDATE() {
		return chgDATE;
	}

	public void setChgDATE(Date chgDATE) {
		this.chgDATE = chgDATE;
	}

	public String getChgUser() {
		return chgUser;
	}

	public void setChgUser(String chgUser) {
		this.chgUser = chgUser;
	}

	public String getChgTerm() {
		return chgTerm;
	}

	public void setChgTerm(String chgTerm) {
		this.chgTerm = chgTerm;
	}
	
	public String getEcmType() {
		return ecmType;
	}

	public void setEcmType(String ecmType) {
		this.ecmType = ecmType;
	}


	@Override
	public String toString(){
		return "\n ECMOrder.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
