package proteus.ecm.hibernate.bean;
 
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name="COUNTRY")
@XmlRootElement(name="Country")
public class Country
implements Serializable
{
	private static final long serialVersionUID = 1L;
 
   @Id
   @Column(name="COUNT_CODE")
   @Field(store=Store.YES, analyze=Analyze.NO)
   private String countCode;
 
   @Column(name="DESCR")
   private String descr;
 
   @Transient
   private String ldescr;
 
   @Column(name="CURR_CODE")
   private String currCode;
 
   @Column(name="TEL_PRFX")
   private String telPrefix;
 
   public Country()
   		{
   }
 
   public Country(String countCode, String descr, String currCode, String telPrefix)
   {
     this.countCode = countCode;
     this.descr = descr;
     this.currCode = currCode;
     this.telPrefix = telPrefix;
   }
 
   public String getCountCode() {
     return this.countCode;
   }
 
   public void setCountCode(String countCode) {
     this.countCode = countCode;
   }
 
   public String getDescr() {
     return this.descr;
   }
 
   public void setDescr(String descr) {
     this.descr = descr;
   }
 
   public String getLdescr() {
     return this.ldescr;
   }
 
   public void setLdescr(String ldescr) {
     this.ldescr = ldescr;
   }
 
   public String getCurrCode() {
     return this.currCode;
   }
 
   public void setCurrCode(String currCode) {
     this.currCode = currCode;
   }
 
   public String getTelPrefix() {
     return this.telPrefix;
   }

   public void setTelPrefix(String telPrefix) {
     this.telPrefix = telPrefix;
   }
 
   public String toString()
   {
     return "\n Country.toString >> [" + new JSONObject(this).toString() + "]";
   }
  }