import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS, } from '@angular/forms';
export class TextAreaValidator {
    constructor() {
        this.bbRequired = false;
        this.requiredMessage = 'Please enter some text';
        this.invalidMessage = 'Please enter valid text';
    }
    validate(control) {
        //console.log('this.invalidMessage'+this.invalidMessage);
        if (!control.value && this.bbRequired) {
            return { message: this.requiredMessage };
        }
        if (control.value) {
            const value = control.value.trim();
            if (this.invalidMessage) {
                return { message: this.invalidMessage };
            }
        }
        return null;
    }
}
TextAreaValidator.decorators = [
    { type: Directive, args: [{
                selector: '[text-area-validator]',
                providers: [
                    { provide: NG_VALIDATORS, useExisting: TextAreaValidator, multi: true }
                ]
            },] },
];
/** @nocollapse */
TextAreaValidator.ctorParameters = () => [];
TextAreaValidator.propDecorators = {
    'bbRequired': [{ type: Input, args: ['required',] },],
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
};
//# sourceMappingURL=text-area-validator.js.map