import { Component, Input } from '@angular/core';
export class BBToggleButtonComponent {
    constructor() {
        this.uxDesign = 'UX3';
        this.bbChecked = false;
        this.bbDisabled = false;
    }
}
BBToggleButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-toggle-button',
                template: `
      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX1'">  
      	</span>
	
      	<span *ngSwitchCase="'UX3'">
        		<md-button-toggle #toggBtn [checked]="bbChecked" [disabled]="bbDisabled">
        			<ng-container *ngTemplateOutlet="content"></ng-container>
        		</md-button-toggle>
	
      		<ng-template #content>
      			<ng-content></ng-content>
      			<span *ngIf = "toggBtn.checked" >
      				<ng-content select="bb-onstate"></ng-content>
      			</span>
      			<span *ngIf = "!toggBtn.checked" >
      				<ng-content select="bb-offstate"></ng-content>
      			</span>	
      		</ng-template>
      	</span>
      </span>
    `,
                styles: [`

    `]
            },] },
];
/** @nocollapse */
BBToggleButtonComponent.ctorParameters = () => [];
BBToggleButtonComponent.propDecorators = {
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'bbChecked': [{ type: Input, args: ['checked',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
};
//# sourceMappingURL=bb-toggle-button.component.js.map