import { BaseBlockComponent } from '../base-block.component';
import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
export class BBNumberComponent extends BaseBlockComponent {
    constructor(validator) {
        super();
        this.validator = validator;
        this.requiredMessage = 'This field is required';
        this.invalidMessage = 'Please enter a valid number';
        this.align = "right";
        this.bbMaxValue = -1; //default value for max
        this.bbMinValue = -1; //default value for min
        this.bbExpression = /^/;
        this.customErrorMessages = {
            'required': () => this.requiredMessage,
            'minlength': (params) => 'The min number of characters is ' + params.requiredLength,
            'maxlength': (params) => 'The max allowed number of characters is ' + params.requiredLength,
            'email': (params) => params.message,
            'password': (params) => params.message,
            'phone': (params) => params.message,
            'number': (params) => params.message
        };
        this.bbType = 'number';
    }
    validate(c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        const isValidNumber = this.bbExpression.test(c.value);
        const message = {
            'number': {
                'message': this.invalidMessage
            }
        };
        if (!isValidNumber) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidNumber ? null : message;
    }
}
BBNumberComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-number',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX3'"> 
      		<md-form-field>
      			<input mdInput #number="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxLength]="bbMaxlength" [minLength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus" [style.textAlign]="align" />
      			<md-hint>
      				<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      			</md-hint>
      		</md-form-field>	
      	</span>
	
      	<span *ngSwitchCase="'UX2'">
      		<span  [ngClass]="{'labelPostion':bbLabelPostion === 'top'}">{{bbLabel}}</span>
      		<input  #number="ngModel" [(ngModel)]="value" [type]="bbType" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxLength]="bbMaxlength" [minLength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus" [style.textAlign]="align"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
	
      	<span *ngSwitchCase="'UX1'">
      	    <input  #number="ngModel" [(ngModel)]="value" [type]="bbType" [required]="bbRequired" [placeholder]="bbPlaceholder" [disabled]="bbDisabled" [value]="bbValue" [maxLength]="bbMaxlength" [minLength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus" [style.textAlign]="align"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
      </span>
    `,
                styles: [`
      .labelPostion{
      display: table;
      }
    `],
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => BBNumberComponent),
                        multi: true
                    },
                    {
                        provide: NG_VALIDATORS,
                        useExisting: BBNumberComponent,
                        multi: true
                    }
                ]
            },] },
];
/** @nocollapse */
BBNumberComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
];
BBNumberComponent.propDecorators = {
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'align': [{ type: Input, args: ['align',] },],
    'bbMaxValue': [{ type: Input, args: ['max',] },],
    'bbMinValue': [{ type: Input, args: ['min',] },],
    'bbExpression': [{ type: Input, args: ['expression',] },],
    'model': [{ type: ViewChild, args: [NgModel,] },],
};
//# sourceMappingURL=bb-number.component.js.map