import { Component, Input } from '@angular/core';
export class BBButtonComponent {
    constructor() {
        this.uxDesign = 'UX3';
        this.bbAutofocus = false;
        this.bbDisabled = false;
    }
}
BBButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-button',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX1'"  > 
      		<button [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      			<ng-container *ngTemplateOutlet="content"></ng-container>
      		</button>
      	</span>
	
      	<span *ngSwitchCase="'UX2'"  > 
      		<button [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      			<ng-container *ngTemplateOutlet="content"></ng-container>
      		</button>
      	</span>
	
      	<span *ngSwitchCase="'UX3'" [ngSwitch]="appearance">
      	    <span *ngSwitchCase="'fab'"> 
      	      	<button md-fab [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      				<ng-container *ngTemplateOutlet="content"></ng-container>	      	
      	      	</button>
      	  	</span>
      		<span *ngSwitchCase="'minifab'"> 
      	      	<button md-mini-fab [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      				<ng-container *ngTemplateOutlet="content"></ng-container>	      	
      	      	</button>
      	  	</span>
      		<span *ngSwitchCase="'simple'">
      			<button md-button [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      				<ng-container *ngTemplateOutlet="content"></ng-container>
      			</button>
      		</span>
      		<span *ngSwitchCase="'raised'">
      			<button md-raised-button [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      				<ng-container *ngTemplateOutlet="content"></ng-container>
      			</button>
      		</span>	
      		  <span *ngSwitchCase="'icon'"> 
      	     	<button md-icon-button [autofocus] = "bbAutofocus" [disabled] = "bbDisabled">
      	     		<md-icon class="md-24">
      	     			<ng-container *ngTemplateOutlet="content"></ng-container>
      	     		</md-icon>
           	</button>
       	</span>	
	 
      	</span>
      	<ng-template #content><ng-content></ng-content></ng-template>
      </span>
    `,
                styles: [`

    `]
            },] },
];
/** @nocollapse */
BBButtonComponent.ctorParameters = () => [];
BBButtonComponent.propDecorators = {
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'bbAutofocus': [{ type: Input, args: ['autofocus',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
    'appearance': [{ type: Input, args: ['appearance',] },],
};
//# sourceMappingURL=bb-button.component.js.map