import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';

import {SubCategory} from '../../ecm-model/subcategory-model';
import {SubCategoryActions} from '../actions';
import * as _ from 'lodash';

export type SubCategoryListState = SubCategory[];

const initialState: SubCategoryListState = [];

export default function (state = initialState, action: Action): SubCategoryListState {
    switch (action.type){
        case SubCategoryActions.LOAD_SUBCATEGORY_SUCCESS: {
            return action.payload;
        }
        case SubCategoryActions.RESET_SUBCATEGORY_LIST: {
            return initialState;
        }
        default: {
            return state;
        }
    }
}