import '@ngrx/core/add/operator/select';
import {compose} from '@ngrx/core/compose';
import {combineReducers} from '@ngrx/store';
import {storeLogger} from 'ngrx-store-logger';

import cartListReducer, * as fromCartList from './cart-list';
import categoryListReducer, * as fromCategoryList from './category-list';
import subCategoryListReducer, * as fromSubCategoryList from './subcategory-list';
import itemListReducer, * as fromItemList from './item-list';
import wishListReducer, * as fromWishList from './wish-list';
import cardListReducer, * as fromSavedCardList from './saved-card-list';
import orderListReducer, * as fromOrderList from './order-list';
//import orderDetailListReducer, * as fromOrderList from './order-detail-list';

import categoryReducer, * as fromCategory from './category';
import subCategoryReducer, * as fromSubCategory from './subcategory';
import itemReducer, * as fromItem from './item';
import locationReducer, * as fromLocation from './location';
import profileReducer, * as fromProfile from './profile-info';
import addressReducer, * as fromAddress from './manage-adress-list';
import menuReducer, * as fromMenu from './menu';

export interface AppState {
    cartItems: fromCartList.CartListState;
    categories: fromCategoryList.CategoryListState;
    subcategories: fromSubCategoryList.SubCategoryListState;
    items: fromItemList.ItemListState;
    wishlistItems: fromWishList.WishListState;
    menuList: fromMenu.MenuState;
    savedCards: fromSavedCardList.CardState;
    orderItems: fromOrderList.OrderListState;
 // orderDetailsItems: fromOrderDetailList.OrderDetailListState;
    
    category: fromCategory.CategoryState;
    subcategory: fromSubCategory.SubCategoryState;
    item: fromItem.ItemState;
    location: fromLocation.LocationState;
    profileInfo: fromProfile.ProfileState;
    Address: fromAddress.AddressState
};

export default compose(storeLogger(),combineReducers)({
//export default compose(combineReducers)({
    cartItems: cartListReducer,
    categories: categoryListReducer,
    subcategories: subCategoryListReducer,
    items: itemListReducer,
    wishlistItems: wishListReducer,
    menuList: menuReducer,
    savedCards: cardListReducer,
    orderItems: orderListReducer,
//  orderDetailsItems: orderDetailListReducer, 
    
    category: categoryReducer,
    subcategory: subCategoryReducer,
    item: itemReducer,
    location: locationReducer,
    profileInfo: profileReducer,
    Address: addressReducer
});