import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {Order} from '../../ecm-model/order-model';

@Injectable()
export class OrderActions {
    

    static LOAD_ORDER_ITEMS = '[orderItems] Load Order Items';
    loadOrderItems(): Action {
        console.log('Kamal Initiate...');
        return {
            type: OrderActions.LOAD_ORDER_ITEMS
        };
    }

    static LOAD_ORDER_ITEMS_SUCCESS = '[orderItems] Load Order Items Success';
    loadOrderItemsSuccess(orderItem): Action {
        
        console.log('[orderItems] Load Orders Success',orderItem.length);
        
        if(!orderItem.length)
        {
            orderItem = [];
        }
        return {
            type: OrderActions.LOAD_ORDER_ITEMS_SUCCESS,
            payload: orderItem
        };
    }
    
    static ADD_NEW_ORDER = '[orderItems] Add new Order';
    addNewOrder(orderItem): Action {
        return {
            type: OrderActions.ADD_NEW_ORDER,
            payload: orderItem
        };
    }

    static ADD_NEW_ORDER_SUCCESS = '[orderItems] Add new Order Success';
    addNewOrderSuccess(orderItem): Action {
        console.log('orderItem-store: ',orderItem);
        return {
            type: OrderActions.ADD_NEW_ORDER_SUCCESS,
            payload: orderItem
        };
    }

    static UPDATE_ORDER = '[orderItems] Update Order';
    updateOrder(orderItem): Action {
        return {
            type: OrderActions.UPDATE_ORDER,
            payload: orderItem
        };
    }

    static UPDATE_ORDER_SUCCESS = '[orderItems] Update Order Success';
    updateOrderoSuccess(orderItem): Action {
        return {
            type: OrderActions.UPDATE_ORDER_SUCCESS,
            payload: orderItem
        };
    }

    static CANCEL_ORDER = '[orderItems] Delete Order';
    deleteOrder(orderItem): Action {
        console.log('Cancel Kamal Initiate...');
        return {
            type: OrderActions.CANCEL_ORDER,
            payload: orderItem
        };
    }

    static DELETE_ORDER_SUCCESS = '[orderItems] Delete Order Success';
    deleteOrderSuccess(orderItem): Action {
        return {
            type: OrderActions.DELETE_ORDER_SUCCESS,
            payload: orderItem
        };
    }
    
//    
//    static TRACK_ORDER_ITEM = '[Order] Track OrderItem';
//    trackOrderItem(item): Action {
//        return {
//            type: OrderActions.TRACK_ORDER_ITEM,
//            payload: item
//        };
//    }
//
//    static TRACK_ORDER_ITEM_SUCCESS = '[Order] Track OrderItem Success';
//    trackOrderItemSuccess(item): Action {
//        return {
//            type: OrderActions.TRACK_ORDER_ITEM_SUCCESS,
//            payload: item
//        };
//    }
//    
    static RESET_ORDER = '[orderItems] Reset ORDER';
    resetOrder(): Action {
        return {
            type: OrderActions.RESET_ORDER
        };
    }
}