import { Component, OnInit, Input, Output, EventEmitter, ViewChild, ElementRef, OnDestroy } from '@angular/core';
import { EcmTemplateInterface } from './ecm-template.component';
import { ItemDetail } from '../../ecm-model/product-detail-model';
import { Router, ActivatedRoute } from '@angular/router';
import { Http } from '@angular/http';
import { EcmCartComponent } from '../../ecm-view/ecm-cart/ecm-cart.component';
import { Item } from '../../ecm-model/product-model';
import { MdDialog, MdDialogRef, MdDialogConfig, MD_DIALOG_DATA } from '@angular/material';
import { RESIZE_EVENT } from '../../ecm-store/ecm-resize';
import { Observable } from 'rxjs/Observable';

import { Store } from '@ngrx/store';
import { AppState } from '../../ecm-store/reducers';

import { EcmRecentViewComponent } from '../../ecm-view/ecm-recent-view/ecm-recent-view.component';

@Component( {
    selector: 'ecm-handicraft',
    templateUrl: './ecm-general.component.html',
    styleUrls: ['./ecm-general.component.css']
})
export class EcmHandicraftComponent implements OnInit, EcmTemplateInterface, OnDestroy {

    @Input() itemDetail: ItemDetail;
    @Input() isAddToCart: boolean = false;
    @Input() inWishlist: boolean = false;
    
    @Output() scrollToReviews = new EventEmitter();
    @Output() doActivity = new EventEmitter();
    
    @ViewChild( 'recentView' ) recentView: EcmRecentViewComponent;
    @ViewChild('itemDetails') itemDetails: ElementRef;
    
    clientWidth: any;
    itemCode;
    cartItems: Observable<Item[]>;
    wishlistItems: Observable<Item[]>;
    enterpise = localStorage.getItem( 'ENTERPRISE' ); 
     
    overview = "We are a renowned manufacture, supplier, wholesalers and traders of decorative basket, artificial flower, artificial flower bunches, rangoli designs, chocolate decoration material, wedding decoration material, candle making material, emboss painting, glass painting, school decoration material, handicrafts trays, handicraft trays-etc and caters to hotels, restaurants, bungalows, school, households-etc.";

    constructor( private route: ActivatedRoute, private router: Router, private http: Http, public dialog: MdDialog, private store: Store<AppState>) { }

    ngOnInit() {
        
        console.log( "Item data in handicraft " + JSON.stringify(this.itemDetail) );
        console.log( "ngOnInit EcmHandicraftComponent Object Keys : " + Object.keys( this.itemDetail ) )
        console.log( this.itemDetail );
        
        this.itemCode = this.itemDetail.itemCode;
        
        this.clientWidth = document.documentElement.clientWidth;
        RESIZE_EVENT.subscribe(data => {
            this.clientWidth = data;
        });

        this.cartItems = this.store.select('cartItems');
        this.cartItems.subscribe( cartItems => {
            if(cartItems.find(x => x.itemCode === this.itemDetail.itemCode))
                this.isAddToCart = true;
            else
                this.isAddToCart = false;
        } );

        this.wishlistItems = this.store.select('wishlistItems');
        this.wishlistItems.subscribe( wishlistItems => {
            if(wishlistItems.find(x => x.itemCode === this.itemDetail.itemCode))
                this.inWishlist = true;
            else
                this.inWishlist = false;
        } );

    }

    ngAfterViewInit() {
        //this.recentView.ngOnInit();
    }

    ngOnDestroy() {
        if ( this.recentView )
            this.recentView.doDestroy( this.itemDetail.itemCode );
    }
 
    createRatings( ratings ) {
        var rating: number[] = [];
        for ( var i = 1; i <= ratings; i++ ) {
            rating.push( i );
        }
        return rating;
    }
    
    viewItem(itemCode) {      
         this.router.navigate(['/detail',itemCode]);
     }
    
    scrollToItemDetails() {
        let offsetTop = this.itemDetails.nativeElement.offsetTop;
        window.scrollTo(0, offsetTop + 60); 
    }
    
    addToWishlist() {
        this.doActivity.emit( { activity: 'ADD_WISHLIST', data: { 'item': this.itemDetail }, 'caller': this, 'callBack': 'changeStatus' });
    }

    removeFromWishlist() {
        this.inWishlist = false;
        this.doActivity.emit( { activity: 'REMOVE_WISHLIST', data: { 'item': this.itemDetail } });
    }

    changeStatus() {
        this.inWishlist = true;
    }
    
    loadItem(itemCode){
        console.log('selected itemCode',itemCode);
        
        this.router.navigate(['/detail',itemCode]);
    }
    
    scrollToReview() {
        if(this.itemDetail.itemRatings.NO_OF_REVIEWS != 0)
            this.scrollToReviews.emit();
    }
    
    getCSV(value:string) {
        let attributeValue: Array<string> = [];
        attributeValue = value.split(',');
        
        return attributeValue;
    }
    
}