import { Component, Input, OnChanges, Inject, Output, EventEmitter, ViewChild } from '@angular/core';
import { Reviews } from '../ecm-model/product-review.model';
import { EcmProductReviewService } from './ecm-product-review.service';
import { ItemDetail } from '../ecm-model/product-detail-model';
import { MdDialog, MdDialogRef, MdDialogConfig, MD_DIALOG_DATA } from '@angular/material';
import { FormBuilder, Validators,NgForm } from '@angular/forms';

import { UserReviewService } from '../user-review/ecm-user-review.service';
@Component( {
    selector: 'ecm-product-review',
    templateUrl: './ecm-product-review.component.html',
    styleUrls: ['./ecm-product-review.component.css']
})
export class EcmProductReviewComponent implements OnChanges {

    @Input() itemDetail: ItemDetail;
    @Output() doActivity = new EventEmitter();
    solrUrl = '/ecm/service/solr/local2do/';
    reviews: Reviews[];
    tabSort: string = "reviewDate desc";
    
    sortBy: string = "item_code:[* TO *]";
    pageCount;
    currentPage: number = 1;
    start = 0;
    searchResponse;
    numFound;
    itemAvgRating;
    itemCode;
    userReview: Reviews;
    editMode: boolean = false;
    
    sortTypes = [
        { value: 'productRating:[5 TO 5]', viewValue: '5 Stars' },
        { value: 'productRating:[4 TO 4]', viewValue: '4 Stars' },
        { value: 'productRating:[3 TO 3]', viewValue: '3 Stars' },
        { value: 'productRating:[2 TO 2]', viewValue: '2 Stars' },
        { value: 'productRating:[1 TO 1]', viewValue: '1 Star' }
    ];

    constructor( private productreviewService: EcmProductReviewService, private userReviewService:UserReviewService, public dialog: MdDialog ) { }

    loadReviews(itemDetail){
        this.itemDetail = itemDetail;
        this.itemCode = this.itemDetail.itemCode;
        this.itemAvgRating = this.itemDetail.itemRatings.AVG_RATING;
        
        this.fetchReviews();
    }
    
    fetchReviews() {
        var solrUrl = this.solrUrl + this.itemCode + '/json/' + this.start + '/' + this.tabSort + '/' + this.sortBy;

        this.productreviewService.getReviews( solrUrl )
            .subscribe( data => {
                this.searchResponse = data;
                if( data.message ) {
                    console.log( data.message );
                }
                else if ( data.response ) {
                    this.reviews = data.response.docs;
                    this.numFound = data.response.numFound;                    
                    this.pageCount = Math.ceil(( this.numFound / 10 ) );
                }
                console.log( this.searchResponse );
            });
    }

    sort() {
        this.fetchReviews();
    }

    filter(filterVal) {
        console.log(filterVal+'filterVal--');
        this.sortBy = "productRating:["+filterVal+" TO "+filterVal+"]";
        this.fetchReviews();
    }

    createPages() {
        var pages: number[] = [];
        for ( var i = 1; i <= this.pageCount; i++ ) {
            pages.push( i );
        }
        return pages;
    }

    nextPage() {
        if ( this.currentPage < this.pageCount ) {
            window.scrollTo( 0, 0 );
            this.start += 10;
            this.currentPage++;
            this.fetchReviews();
        }

    }

    prevPage() {
        if ( this.currentPage >= 2 ) {
            window.scrollTo( 0, 0 );
            this.start += 10;
            this.currentPage--;
            this.fetchReviews();
        }
    }

    goToPage( page ) {
        if ( !( this.currentPage == page ) ) {
            window.scrollTo( 0, 0 );
            this.currentPage = page;
            this.start = ( ( page + 1 ) * 10 ) - 10;
            this.fetchReviews();
        }
    }

    onLastPage() {
        if ( this.currentPage == this.pageCount ) {
            return true;
        }
        else {
            return false;
        }
    }

    onSelectChange( $event ) {
        console.log( 'index => ', $event.index );
        if ( $event.index == 0 )
        {
            this.tabSort = 'reviewDate desc';
            this.fetchReviews();
        }
        else if ( $event.index == 1 )
        {
            this.tabSort = 'productUsfulCnt desc';
            this.fetchReviews();
        }
    }
    
    createRatings(ratings){
        var rating: number[] = [];
        for(var i = 1; i <= ratings; i++){
         rating.push(i);
        }
        return rating;
    }
    
    ngOnChanges(){
        if ( this.itemDetail ) {
            this.itemCode = this.itemDetail.itemCode;
            this.itemAvgRating = this.itemDetail.itemRatings.AVG_RATING;
        }
        this.fetchReviews();
    }
    
    showEditMode(){
        if(this.checkUser()){
            this.userReviewService.itemCode = this.itemCode;
            this.editMode = true;
        }else {
            this.doActivity.emit( { activity: 'SHOW_SIGNIN_PANEL'} );
        }
    }
    
    checkUser(){
        var userInfo = localStorage.getItem( 'userInfo' );
        if ( userInfo !== 'undefined' && userInfo !== null && userInfo !== 'null' ) 
        {
            return userInfo;
        }
        else 
        {
            return userInfo;
        }
    }
    
}
