import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
import { Store } from '@ngrx/store';

import { ItemDetail } from '../ecm-model/product-detail-model';
import { HostUrlService } from '../host-url.service';

@Injectable()
export class EcmProductDetailService {

 //   private SERVICE_URL = '/ecm/service/L2D01/category/detail/';  // URL to web service
    private SERVICE_URL = '/ecm/service';
    constructor ( public hostUrlService : HostUrlService,private http: Http) {}

    getItemDetail (itemCode : string): Observable<ItemDetail> {
        let siteCode = localStorage.getItem('SITE_CODE');
        let itemsUrl = this.hostUrlService.hostUrl+this.SERVICE_URL + '/' + siteCode + '/category' + '/detail' + '/' + itemCode ;
        let headers = new Headers({ 'Content-Type': 'application/json' });
        let options = new RequestOptions({ headers: headers });

        return this.http.get(itemsUrl, options)
                        .map(this.extractData)
                        .catch(this.handleError);
    }
    
    private extractData(res: Response) {
      let respJson = res.json();
      
      for( let key of Object.keys( respJson ) )
      {
          console.log( "getItemDetail itemDetail ==> key: " + key )
          let data = respJson[key];
          try 
          {
              respJson[key] = JSON.parse( data );
              console.log( "getItemDetail itemDetail try : " + respJson[key] );
          }
          catch(e)
          {
              respJson[key] = data;
              console.log( "getItemDetail itemDetail catch : " + respJson[key] );
          }
      }
      console.log('extractData[' + JSON.stringify(respJson) + ']');
      return respJson || { };
    }

    private handleError (error: Response | any) {
      // In a real world app, we might use a remote logging infrastructure
      let errMsg: string;
      if (error instanceof Response) {
        const body = error.json() || '';
        const err = body.error || JSON.stringify(body);
        errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
      } else {
        errMsg = error.message ? error.message : error.toString();
      }
      console.error('Service handleError:' + errMsg);
      return Observable.throw(errMsg);
    }
}
