import { Component, OnInit, Input, Injectable } from '@angular/core';
import { Location } from '@angular/common';
import { Store } from '@ngrx/store';
import {AppState} from '../ecm-store/reducers';
import { ItemDetail } from '../ecm-model/product-detail-model';
import { Category } from '../ecm-model/category-model';
import { SubCategory } from '../ecm-model/subcategory-model';
import { Item } from '../ecm-model/product-model';
import { Observable } from 'rxjs/Observable';

interface IBreadcrumb {
    label: string;
    url: string;
}

@Injectable()
export class Breadcrumbs {
  breadcrumbsList: IBreadcrumb[] = [];

  get breadcrumbs(): IBreadcrumb[] { return this.breadcrumbsList; }

  set breadcrumbs(breadcrumbs: IBreadcrumb[]) {
    console.log('set breadcrumbs',breadcrumbs);  
    this.breadcrumbsList = breadcrumbs;
  }

  constructor() {
      
  }
}

@Component( {
    selector: 'ecm-breadcrumbs',
    templateUrl: './ecm-breadcrumbs.component.html',
    styleUrls: ['./ecm-breadcrumbs.component.css']
})
export class EcmBreadcrumbsComponent implements OnInit {
    
    @Input() itemDetail: ItemDetail;
    @Input() pageName;
    breadcrumbs: IBreadcrumb[] = [];

    category;
    subcategory;
    item : Observable<Item>;
    
    constructor( private _location: Location, private store: Store<AppState>, public breadcrumbSerivce: Breadcrumbs) { }

    ngOnInit() {    
    }

    backClicked() {
        //TODO : Pagewise Back click
        this._location.back();
    }
    
    getBreadCrummbs(){
        return this.breadcrumbSerivce.breadcrumbs;
    }
}





