package proteus.ecm.schedule;

import java.util.Date;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.cache.dao.SystemCache;
import proteus.ecm.hibernate.bean.ECMParm;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.dao.CategoryDAO;
import proteus.ecm.hibernate.dao.SystemMasterDAO;

public class StartUp {
	
	public void loadOnStartUp(String siteCode) 
	{
		try
		{
			CategoryDAO categoryDAO = new CategoryDAO();
			SystemMasterDAO systemMasterDAO = new SystemMasterDAO();
			System.out.println("Inside loadOnStartUp method of StartUp Job");
			System.out.println("Data Fetching Start..." + new Date() );
			
			String topRank = "1";
			ECMParm ecmParam =  systemMasterDAO.fetchEcmParms("top_cat_rank", true).get("top_cat_rank");
			if( ecmParam != null )
			{
				topRank = ecmParam.getVarValue();
			}
			System.out.println("TOP_CAT_RANK [" + topRank + "] ecmParam[" + ecmParam + "]");
			
			System.out.println("Site Fetching Start..." + new Date() );
			SystemCache systemCache = new SystemCache();
			//List<SiteMaster> sites = systemCache.getCachedSites(CacheManager.SYSTEM_CACHE_NAME);
			SiteMaster site = systemCache.getCachedSite(siteCode, CacheManager.SYSTEM_CACHE_NAME);
			
			if(site == null)
			{
				//systemMasterDAO.fetchAllSites(CacheManager.SYSTEM_CACHE_NAME);
				systemMasterDAO.fetchSite(siteCode, CacheManager.SYSTEM_CACHE_NAME);
				System.out.println("Site Fetching End..." + new Date() );
				site = systemCache.getCachedSite(siteCode, CacheManager.SYSTEM_CACHE_NAME);
				String cacheName = "CACHE_" + siteCode;
				
				System.out.println("Site Items ["+siteCode+"] Fetching Start..." + new Date() );
				systemMasterDAO.fetchSiteItems(siteCode, cacheName);
				System.out.println("Site Items ["+siteCode+"] Fetching End..." + new Date() );
				
				System.out.println("All Categories ["+siteCode+"] Fetching Start..." + new Date() );
				categoryDAO.fetchAllCategories(cacheName, siteCode);
				System.out.println("All Categories ["+siteCode+"] Fetching End..." + new Date() );
				
				System.out.println("All Sub Categories ["+siteCode+"] Fetching Start..." + new Date() );
				categoryDAO.fetchAllSubCategories(cacheName, siteCode);
				System.out.println("All Sub Categories ["+siteCode+"] Fetching End..." + new Date() );
				
				System.out.println("All Items ["+siteCode+"] Fetching Start..." + new Date() );
				categoryDAO.fetchAllItems(cacheName, siteCode);
				System.out.println("All Items ["+siteCode+"] Fetching End..." + new Date() );
				
				System.out.println("Trending Items ["+siteCode+"] Fetching Start..." + new Date() );
				categoryDAO.fetchTrendingItems(topRank, siteCode, cacheName);
				System.out.println("Trending Items ["+siteCode+"] Fetching End..." + new Date() );
			}	
					
			System.out.println("Data Fetching End..." + new Date() );
		}
		catch (Exception e) 
		{
			System.out.println("Exception Inside schedule method of ECMScheduleEJB" + e.getMessage());
			e.printStackTrace();
		}
	}

}
