package proteus.ecm.hibernate.dao;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map.Entry;
import java.util.Set;

import org.hibernate.HibernateException;
import org.hibernate.query.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONException;
import org.json.JSONObject;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.cache.bean.ECMUserTracker;
import proteus.ecm.cache.dao.SystemCache;
import proteus.ecm.cache.dao.UserActivityCache;
import proteus.ecm.hibernate.bean.Country;
import proteus.ecm.hibernate.bean.ECMItemRating;
import proteus.ecm.hibernate.bean.ECMUserActivity;
import proteus.ecm.hibernate.bean.EntityAddress;
import proteus.ecm.hibernate.bean.UserProfile;
import proteus.ecm.hibernate.bean.EntityPayMethod;
import proteus.ecm.hibernate.bean.State;
import proteus.ecm.hibernate.util.HibernateUtil;

public class UserActivityDAO {
	private String siteTranDB = "DEFAULT";
	public final static String RECENT_VIEW = "0";
	public final static String ADD_CART = "1";
	public final static String WISHLIST = "2";
	
	private List<ECMUserActivity> fetchUserAllData(String userId, String siteCode)
	{
		List<ECMUserActivity> userData = new ArrayList<ECMUserActivity>();

		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery(
					"FROM ECMUserActivity WHERE userId = '" + userId + "' AND siteCode = '" + siteCode + "'"+" ORDER BY activityDate ASC");

			userData = query.getResultList();

			System.out.println("User data: [" + userData + "]");

		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}

		return userData;
	}

	private List<ECMUserActivity> fetchDataByItem(String userId, String siteCode, String itemCode)
	{
		List<ECMUserActivity> userData = new ArrayList<ECMUserActivity>();

		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ECMUserActivity WHERE userId = '" + userId + "' AND siteCode = '"
					+ siteCode + "' AND itemCode = '" + itemCode + "'");

			userData = query.getResultList();

			System.out.println("User data: [" + userData + "]");

		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return userData;
	}

	private List<ECMUserActivity> fetchDataByActivityType(String userId, String siteCode, String activityType)
	{
		List<ECMUserActivity> userData = new ArrayList<ECMUserActivity>();

		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ECMUserActivity WHERE userId = '" + userId + "' AND siteCode = '"
					+ siteCode + "' AND activityType = '" + activityType + "'");
			
			userData = query.getResultList();

			System.out.println("User data: [" + userData + "]");

		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return userData;
	}

	public ECMUserActivity fetchDataByActivityType(String userId, String siteCode, String activityType, String itemCode)
	{
		ECMUserActivity userData = null;

		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory("DEFAULT").openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ECMUserActivity WHERE userId = '" + userId + "' AND siteCode = '"
					+ siteCode + "' AND itemCode = '" + itemCode + "' AND activityType = '" + activityType + "'");

			List<ECMUserActivity> userDataLst = query.getResultList();
			if (userDataLst != null && userDataLst.size() > 0) {
				userData = userDataLst.get(0);
			}

			System.out.println("User data: [" + userData + "]");
			session.close();

		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return userData;
	}

	private void insertOrUpdate(ECMUserActivity userData, String editFlag)
	{
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory("DEFAULT").openSession();
			Transaction tx = session.beginTransaction();
			if ("ADD".equalsIgnoreCase(editFlag)) {
				userData.setTranId(getNextSequence());
				session.save(userData);
			} else {
				session.update(userData);
			}
			tx.commit();
			session.close();
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
	}

	private void deleteUserData(ECMUserActivity userData)
	{
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			Transaction tx  = session.beginTransaction(); //chitra
			session.delete(userData);
			tx.commit();
			session.close();
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}

	public void insertOrUpdate(String userId, String siteCode, String itemCode, String activityType, String activityDetail, Date activityDate)
	{
		System.out.println("Inside updateUserData: ");
		System.out.println("userId:[" + userId + "]" + " itemCode: [" + itemCode + "]" + "activityType[" + activityType
				+ "]" + "siteCode: [" + siteCode + "]");
		try
		{	
			if(activityDate == null)
			{
			 activityDate = new Date();
			}
			String flag = "EDIT";
			userId = String.format("%-10s", userId);
			itemCode = String.format("%-10s", itemCode);
			ECMUserActivity userData = fetchDataByActivityType(userId, siteCode, activityType, itemCode);
			
			if (userData == null)
			{
				userData = new ECMUserActivity();
				flag = "ADD";
			}
			
			userData.setUserId(userId);
			userData.setSiteCode(siteCode);
			userData.setItemCode(itemCode);
			userData.setActivityType(activityType);
			userData.setActivityDetail(activityDetail);
			userData.setActivityDate(activityDate);

			insertOrUpdate(userData, flag);
		}
		catch (Exception e)
		{
			System.out.println("Exception :");
			System.out.println(e.getMessage());
		}
	}

	public void deleteUserData(String userId, String siteCode, String itemCode, String activityType)
	{
		System.out.println("Deleting UserActivity \n userId:[" + userId + "]" + " siteCode:[" + siteCode + "]"
				+ "activityType:[" + activityType + "]");
		try
		{
			userId = String.format("%-10s", userId);
			itemCode = String.format("%-10s", itemCode);
			ECMUserActivity userData = fetchDataByActivityType(userId, siteCode, activityType, itemCode);
			userData.setUserId(userId);
			userData.setSiteCode(siteCode);
			userData.setItemCode(itemCode);
			userData.setActivityType(activityType);
			deleteUserData(userData);

		}
		catch (Exception e)
		{
			System.out.println("Exception :");
			System.out.println(e.getMessage());
		}
	}

	public void storeUserCache(String userId, String siteCode, String cacheName)
	{
		List<ECMUserActivity> userData = fetchUserAllData(userId, siteCode);
		UserActivityCache userActivityCache = new UserActivityCache();

		for (ECMUserActivity userInfo : userData)
		{
			if (userInfo.getActivityType().equalsIgnoreCase(RECENT_VIEW))
			{
				userActivityCache.storeRecentViewItem(userInfo.getItemCode(), userInfo.getActivityDate(), cacheName, userId);
				
			} else if (userInfo.getActivityType().equalsIgnoreCase(WISHLIST))
			{
				userActivityCache.storeWishlistItem(userInfo.getItemCode(), userInfo.getActivityDetail(), cacheName, userId);
			
			} else if (userInfo.getActivityType().equalsIgnoreCase(ADD_CART))
			{
				userActivityCache.storeCartItem(userInfo.getItemCode(), userInfo.getActivityDetail(), userId, cacheName);
			}
		}
	}

	public void storeSessionData(String userId, String sessionId, String cacheName, String siteCode)
	{
		UserActivityCache userActivityCache = new UserActivityCache();

		Set<Entry<String, Date>> items = null;
		ECMUserTracker userBean = userActivityCache.getCachedUserData(sessionId, cacheName);

		if (userBean != null)
		{
			for (Entry<String, Date> entry : userBean.getBrowsedProducts().entrySet())
			{
				insertOrUpdate(userId, siteCode, entry.getKey(), RECENT_VIEW, "", entry.getValue());
			}

			for (Entry<String, String> entry : userBean.getCartProducts().entrySet())
			{
				insertOrUpdate(userId, siteCode, entry.getKey(), ADD_CART, entry.getValue(), null);
			}
		}

	}
	
	private void updateLikes(ECMItemRating reviewData)
	{
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			
			Transaction tx = session.beginTransaction();
			session.update(reviewData);
			tx.commit();
			session.close();		
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}	
	}
	
	private void addReview(ECMItemRating reviewData)
	{
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			
			Transaction tx = session.beginTransaction();
			session.saveOrUpdate(reviewData);
			tx.commit();
			session.close();		
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}	
	}
	
	public void updateLikes(String itemCode, String siteCode, String reviewBy, String usefulCnt, String notUsefulCnt){
		ECMItemRating reviewData = new ECMItemRating();
		reviewBy = String.format("%-10s", reviewBy);
		siteCode = String.format("%-10s", siteCode);
		
		System.out.println("Update EcmItemRating for: itemcode:["+itemCode+"] reviewBy:["+reviewBy+"[ siteCode:["+siteCode+"] usefulCnt:["+usefulCnt+"] notUsefulCnt:["+notUsefulCnt+"]");
		reviewData.setItemCode(itemCode);
		reviewData.setSiteCode(siteCode);
		reviewData.setUserId(reviewBy);
		reviewData.setUsefulCnt(Integer.parseInt(usefulCnt));
		reviewData.setNotUsefulCnt(Integer.parseInt(notUsefulCnt));
		
		updateLikes(reviewData);
	}
	
	public void addReview(String siteCode, String itemCode, String reviewBy, int productRating, String productRemarks, String productComments, Date date){
		ECMItemRating reviewData = new ECMItemRating();
		reviewBy = String.format("%-10s", reviewBy);
		siteCode = String.format("%-10s", siteCode);
		
		reviewData.setSiteCode(siteCode);
		reviewData.setItemCode(itemCode);
		reviewData.setUserId(reviewBy);
		reviewData.setRating(productRating);
		reviewData.setRemarks(productRemarks);
		reviewData.setComments(productComments);
		reviewData.setChgUsr(reviewBy);
		reviewData.setChgTerm("127.0.0.1");
		reviewData.setChgDate(date);
		
		addReview(reviewData);
	}
	
	public ECMItemRating getUserReview(String userId, String itemCode, String siteCode){
		
		ECMItemRating userReview = null;
		
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ECMItemRating WHERE userId = '" + userId + "' AND siteCode = '"
					+ siteCode + "' AND itemCode = '" + itemCode + "'");
			
			if(query.getResultList().size() > 0){
				List<ECMItemRating> reviews = query.getResultList(); 
				userReview = reviews.get(0);
			}

			System.out.println("User review: [" + userReview + "]");
			
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		
		return userReview;
	}
	
	private String getNextSequence()
	{
		String squence = "";
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("SELECT usr_act_seq.nextVal FROM DUAL ");
			
			List seqList = query.getResultList();
			
			if (seqList != null && seqList.size() > 0)
			{
				int seq = ((BigDecimal) seqList.get(0)).intValue();
				System.out.println("squence: [" + seq + "]");
				squence = String.format(String.format("%%0%dd", 10), seq);
			}
			
			System.out.println("squence: [" + squence + "]");
			session.close();
			
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return squence;
	}
	
	
	   public List<EntityAddress> getAddresses(String userId)
	  {
		 List<EntityAddress> addressList = new ArrayList();
	     SystemCache systemCache = new SystemCache();
	    try
	    {
	       Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
	
	       Query query = session.createQuery("FROM EntityAddress WHERE entityCode = '" + userId + "' ");
	       System.out.println("getAddresses from UserActivityDao  query: [" + query + "]");
	       addressList = query.getResultList();
	
	       System.out.println("getAddresses from UserActivityDao Before addressList: [" + addressList + "]");
	       for (EntityAddress addr : addressList) {
	         State state = systemCache.getCachedState(CacheManager.SYSTEM_CACHE_NAME, addr.getStateCode());
	         if (state != null) {
	           addr.setStateDescr(state.getDescr());
	        }
	         Country country = systemCache.getCachedCountry(CacheManager.SYSTEM_CACHE_NAME, addr.getCountCode());
	         if (country != null) {
	           addr.setCountDescr(country.getDescr());
	        }
	         System.out.println("getAddresses state[" + state + "]country[" + country + "]");
	
	         String uName = addr.getUserName();
	         if (uName != null) {
	           String[] uNameArr = uName.split(" ");
	           addr.setFirstName(uNameArr[0]);
	           addr.setLastName(uNameArr[1]);
	        }
	      }
	       System.out.println("getAddresses from UserActivityDao After addressList: [" + addressList + "]");
	       session.close();
	    }
	    catch (HibernateException e)
	    {
	       System.out.println("HibernateException :");
	       System.out.println(e.getMessage());
	    }
	     return addressList;
	  }
	
	public  EntityAddress getAddress(String userId, String lineNo){	
		
		EntityAddress address = null;
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			System.out.println("Inside getAddress userId: [" + userId + "]lineNo: [" + lineNo + "]");
			Query query = session.createQuery("from EntityAddress where entityCode='"+userId+"' AND lineNo ='" + lineNo + "' ");

			System.out.println("Inside getAddress query: [" + query + "]");
			List<EntityAddress> addressList = query.getResultList();
			if(addressList != null && addressList.size() > 0){
				address = addressList.get(0);
				System.out.println("Inside getAddress in UserActivityDao: [" + address + "]");
			}	
			System.out.println("getAddress: [" + address + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return address;
	}
	
	public void saveAddress(String userId, JSONObject addressData)
	{
		try 
		{
			String lineNo = addressData.getString("lineNo");
			String isDefaultAddress = addressData.getString("isDefault");
			
			System.out.println("entityAddress B4>>  lineNo[" + lineNo + "]isDefaultAddress[" + isDefaultAddress + "]addressData[" + addressData + "]");
			if( "Y".equalsIgnoreCase(isDefaultAddress) )
			{
				resetIsDefault(userId); 
			}
			
			EntityAddress entityAddress = getAddress(userId, lineNo);
			if( entityAddress != null ) {
				//EDIT MODE
				System.out.println("entityAddress B4>>" + entityAddress);
				entityAddress.toEntityAddress(addressData);
				System.out.println("entityAddress AFTER>>" + entityAddress);
				
				// 1. Get Session object
				Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
				
				Transaction tx = session.beginTransaction();
				session.update(entityAddress);
				tx.commit();
				session.close();		
			}
			else {
				//ADD MODE
				entityAddress = new EntityAddress();
				entityAddress.setEntityCode(userId);//PK field
				entityAddress.setLineNo(lineNo);//PK field
				entityAddress.setEntityType("U"); //Default U for ECM User.
				System.out.println("entityAddress B4>>" + entityAddress);
				entityAddress.toEntityAddress(addressData);
				System.out.println("entityAddress AFTER>>" + entityAddress);
				
				// 1. Get Session object
				Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
				
				Transaction tx = session.beginTransaction();
				session.save(entityAddress);
				tx.commit();
				session.close();
			}
		} 
		catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		} 
		catch (JSONException e) {
			System.out.println("JSONException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
	}
	

	private void resetIsDefault(String userId) 
	{
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery(" UPDATE EntityAddress set isDefault = 'N' where entityCode = '" + userId + "' " );
			int result = query.executeUpdate();
			System.out.println("getAddresses from UserActivityDao  query: [" + query + "]result: [" + result + "]");// No of rows for User expected
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}

	public String deleteAddress(String userId, String lineNo) {
		EntityAddress userAddress = new EntityAddress();
		try {
			Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();

			Query query = session.createQuery(
					" from EntityAddress WHERE entityCode = '" + userId + "' AND lineNo = '" + lineNo + "' ");

			List userAddressList = query.getResultList();

			if ((userAddressList != null) && (userAddressList.size() > 0)) {
				userAddress = (EntityAddress) userAddressList.get(0);
			}

			Transaction tx = session.beginTransaction(); //chitra
            session.delete(userAddress);
			tx.commit();
			session.close();
		} catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return lineNo;
	}
	

	public UserProfile getProfile(String userId)
	{
		UserProfile userProfile = null;
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			System.out.println("Inside getProfile userId: [" + userId + "]");
			Query query = session.createQuery("from UserProfile where userCode='"+userId+"'");
			System.out.println("Inside getPrductRating query: [" + query + "]");
			List<UserProfile> userList = query.getResultList();
			System.out.println("getPrductRating productList [" + userList + "]");
			if(userList != null && userList.size() > 0){
				userProfile = userList.get(0);
				
				Date birthDate = userProfile.getBirthDate();
				String birthDateStr = HibernateUtil.getValidDB2APPLDate(birthDate.toString());
				System.out.println("B4 birthDate[" + birthDate + "]");
				birthDate = HibernateUtil.getDateObject(birthDateStr, HibernateUtil.APPL_DATE_FORMAT);
				System.out.println("After birthDate[" + birthDate + "]");
				userProfile.setBirthDate(birthDate);
				
				String uName = userProfile.getUserName();
				if( uName != null ){
					String[] uNameArr = uName.split(" ");
					if( uNameArr.length > 0 )
					userProfile.setFirstName(uNameArr[0]);
					if( uNameArr.length > 1 )
					userProfile.setLastName(uNameArr[1]);
				}
				System.out.println("Inside getProfile in UserActivityDao: [" + userProfile + "]");
			}	
			System.out.println("getProfile: [" + userProfile + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return userProfile;
	}

	public void saveProfile(String userId, JSONObject profileData)
	{
		try 
		{
			UserProfile userProfile = getProfile(userId);
			if( userProfile != null ) {
				System.out.println("userProfile B4>>" + userProfile);
				userProfile.toUserProfile(profileData);
				System.out.println("userProfile AFTER>>" + userProfile);
				
				// 1. Get Session object
				Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
				Transaction tx = session.beginTransaction();
				session.update(userProfile);
				
				tx.commit();
				session.close();		
			}
			else {
				//Not to be in this case 
				System.out.println("Not to be in this case :: USER PROFILE NULL");
			}
		} 
		catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		} 
		catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public  List<ECMItemRating> getProductReviews(){
		
		List<ECMItemRating> reviewsList = new ArrayList<ECMItemRating>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("from ECMItemRating");
			reviewsList = query.getResultList();
			System.out.println("ECMItemRating from UserActivityDao  : [" + reviewsList + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return reviewsList;
	}
	
	public  ECMItemRating getPrductReview(String id){	
		ECMItemRating product =new ECMItemRating();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			System.out.println("Inside getPrductRating id: [" + id + "]");
			Query query = session.createQuery("from ECMItemRating where itemCode='"+id+"'");
			System.out.println("Inside getPrductRating query: [" + query + "]");
			List<ECMItemRating> productList = query.getResultList();
			System.out.println("getPrductRating productList [" + productList + "]");
			if(productList != null && productList.size() > 0){
				product = productList.get(0);
				System.out.println("Inside getPrductRating in UserActivityDao: [" + product + "]");
			}	
			System.out.println("getPrductRating: [" + product + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return product;
	}
	
	public String saveProductReview(String data) throws JSONException{
	    System.out.println("Inside saveProductReview UserAcitivyDao data is" +data);
		return null;
	}
	
	public List<EntityPayMethod> getCards(String userId){
		List<EntityPayMethod> cardsList = new ArrayList<EntityPayMethod>();

		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery(
					"FROM EntityPayMethod WHERE entityCode = '" + userId + "' ORDER BY lineNo ASC");

			cardsList = query.getResultList();
			
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		
		return cardsList;
	}
	
	public void saveCard(String userId, JSONObject cardData) {
		
		try
		{
			EntityPayMethod userCard = new EntityPayMethod();
			userCard.toSaveCard(userId, cardData);
			
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory("DEFAULT").openSession();
			Transaction tx = session.beginTransaction();
			session.save(userCard);

			tx.commit();
			session.close();
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	public void deleteCard(String userId, String lineNo) {
		
		EntityPayMethod userCard = new EntityPayMethod();
//		userCard.setEntityCode(userId);
//		userCard.setLineNo(lineNo);
		
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			
			Query query = session.createQuery("FROM EntityPayMethod WHERE entityCode = '" + userId + "' AND lineNo = '"
					+ lineNo + "'");

			List<EntityPayMethod> userCardList = query.getResultList();
			if (userCardList != null && userCardList.size() > 0) {
				userCard = userCardList.get(0);
			}
			
			Transaction tx  = session.beginTransaction(); //f
			session.delete(userCard);
			tx.commit();
			session.close();
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}

	public void removeUserReview(String userId, String itemCode, String siteCode) {
		ECMItemRating userReview = getUserReview(userId, itemCode, siteCode);
		
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			Transaction tx  = session.beginTransaction(); //chitra
			session.delete(userReview);
			tx.commit();
			session.close();
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}
	
}