package proteus.ecm.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;


@Indexed
@Entity
@Table(name = "ECM_ITEM_RATING")
@XmlRootElement(name = "ItemRating")
public class ECMItemRating implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name="SITE_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String siteCode;
	
	@Id
	@Column(name="ITEM_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String itemCode;
	
	@Id
	@Column(name="USER_ID")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String userId;
	
	@Column(name="RATING")
	private int rating;

	@Column(name="REMARKS")
	private String remarks;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="USEFUL_CNT")
	private int usefulCnt;
	
	@Column(name="NOT_USEFUL_CNT")
	private int notUsefulCnt;
	
	@Column(name="CHG_USER")
	private String chgUsr;
	
	@Column(name="CHG_TERM")
	private String chgTerm;
	
	@Column(name="CHG_DATE")
	private Date chgDate;
	
	public ECMItemRating() {
	}

	public ECMItemRating(String siteCode, String itemCode, String userId, int rating, String remarks, String comments, int usefulCnt, int notUsefulCnt, String chgUsr, String chgTerm, Date chgDate) {
		this.siteCode = siteCode;
		this.itemCode = itemCode;
		this.userId = userId;
		this.rating = rating;
		this.remarks = remarks;
		this.comments = comments;
		this.usefulCnt = usefulCnt;
		this.notUsefulCnt = notUsefulCnt;
		this.chgUsr = chgUsr;
		this.chgTerm = chgTerm;
		this.chgDate = chgDate;
	}

	public String getSiteCode() {
		return siteCode;
	}

	@XmlElement
	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}

	public String getItemCode() {
		return itemCode;
	}

	@XmlElement
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getUserId() {
		return userId;
	}

	@XmlElement
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public int getRating() {
		return rating;
	}

	@XmlElement
	public void setRating(int rating) {
		this.rating = rating;
	}

	public String getRemarks() {
		return remarks;
	}

	@XmlElement
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getComments() {
		return comments;
	}

	@XmlElement
	public void setComments(String comments) {
		this.comments = comments;
	}

	public int getUsefulCnt() {
		return usefulCnt;
	}

	@XmlElement
	public void setUsefulCnt(int usefulCnt) {
		this.usefulCnt = usefulCnt;
	}

	public int getNotUsefulCnt() {
		return notUsefulCnt;
	}

	@XmlElement
	public void setNotUsefulCnt(int notUsefulCnt) {
		this.notUsefulCnt = notUsefulCnt;
	}
	
	public String getChgUsr() {
		return chgUsr;
	}
	
	@XmlElement
	public void setChgUsr(String chgUsr) {
		this.chgUsr = chgUsr;
	}
	
	public String getChgTerm() {
		return chgTerm;
	}
	
	@XmlElement
	public void setChgTerm(String chgTerm) {
		this.chgTerm = chgTerm;
	}

	public Date getChgDate() {
		return chgDate;
	}
	
	@XmlElement
	public void setChgDate(Date chgDate) {
		this.chgDate = chgDate;
	}

	@Override
	public String toString(){
		return "\n ItemRating.toString >> [" + new JSONObject(this).toString() + "]";
	}

}
