package proteus.ecm.cache.bean;


import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ECMUserTracker 
{
	Map<String, String> cartProducts = new HashMap<String, String>();
	Map<String, Date> browsedProducts = new LinkedHashMap<String, Date>();
	Map<String, String> wishlistedProducts = new HashMap<String, String>();
	
	public Map<String, String> getCartProducts() {
		return cartProducts;
	}

	public Map<String, Date> getBrowsedProducts() {
		return  browsedProducts;
	}

	public Map<String, String> getWishlistedProducts() {
		return wishlistedProducts;
	}

	public void addToCartProduct(String itemCode, String cartDetails) {	
			this.cartProducts.put(itemCode, cartDetails);		
	}

	public void removeCartProduct(String itemCode) {
		if( "ALL".equalsIgnoreCase(itemCode) ) {
			this.cartProducts.clear();
		}
		else if( this.cartProducts.containsKey(itemCode) ) {
			this.cartProducts.remove(itemCode);
		}
	}

	public void setBrowsedProduct(String itemCode, Date date) {		
		if( this.browsedProducts.containsKey(itemCode) ) {
			this.browsedProducts.remove(itemCode);
		}
		this.browsedProducts.put(itemCode, date);		
	}

	public void setWishlistedProducts(String itemCode, String wishlistDetails) {		
			this.wishlistedProducts.put(itemCode, wishlistDetails);		
	}
	
	public void removeWishlistedProducts(String itemCode) {
		if( "ALL".equalsIgnoreCase(itemCode) ) {
			this.wishlistedProducts.clear();
		}
		else if( this.wishlistedProducts.containsKey(itemCode) ) {
			this.wishlistedProducts.remove(itemCode);
		}
	}
}
