import { Component, Input, Output, EventEmitter, ViewEncapsulation, OnInit, ElementRef, ViewChild } from '@angular/core';
import { Card } from './card.model';
import { IScreenEditor } from '../screen-editor';
import { MdDialog, MdDialogRef } from '@angular/material';

import { CardScreenComponent } from './card-screen/card-screen.component';
import { ECMConfirmDialog } from '../../ecm-view/ecm-cart/ecm-cart.component';

import { Observable } from 'rxjs/Observable';

declare var require: any;

@Component( {
    selector: 'card-manager',
    templateUrl: './card-manager.component.html',
    styleUrls: ['./card-manager.component.css'],
    encapsulation: ViewEncapsulation.None
})
export class CardEditor implements OnInit, IScreenEditor {


    @Input() editorId: string;
    @Input() editMode: string = 'V';
    @Input() card: Card;

    @Output() onDelete: EventEmitter<Card> = new EventEmitter<Card>();
    @Output() onAddNew: EventEmitter<Card> = new EventEmitter<Card>();
    @Output() onSave: EventEmitter<Card> = new EventEmitter<Card>();
    @Output() onDiscard: EventEmitter<Card> = new EventEmitter<Card>();

    @ViewChild( 'cardScreen' ) child: CardScreenComponent;
    public childForm;

    newCard: Card;
    oldCard: Card;
    showAdd: boolean = false;

    addType = [{ viewValue: 'Home' }, { viewValue: 'Office/Commercial' }];
    advance = [{ viewValue: 'Set as delivery address' }, { viewValue: 'Set as Billing address' }, { viewValue: 'Set as default' }];

    constructor( public dialog: MdDialog ) {

    }

    ngOnInit() {
        console.log( "ID", this.editorId );
        //this.setCardBank( this.card.acctNumber );
    }

    ngAfterViewChecked(): void {
        if ( this.showAdd ) {
            this.childForm = this.child.cardForm;
        }
    }

    addNew() {
        this.newCard = new Card();
        this.showAdd = true;
        localStorage.setItem( 'editorId', this.editorId );
    }

    edit() {
        this.oldCard = this.simpleClone( this.card );
        this.editMode = 'E';
        localStorage.setItem( 'editorId', this.editorId );
    }

    save() {
        console.log( 'save', this.showAdd, this.card, this.newCard );
        this.newCard.acctNumber = this.newCard.acctNumber.replace( /\D/g, '' );

        if ( this.showAdd ) {
            this.setCardType( this.newCard.acctNumber );
        }
        else {
            this.onSave.emit( this.card );
        }
        console.log( 'save...' );
    }

    reInitialize() {
        this.showAdd = false;
        this.newCard = new Card();
        localStorage.removeItem( 'editorId' );
        if ( this.editMode == 'E' ) {
            this.editMode = 'V';
        }
    }

    cancel() {
        this.showAdd = false;
        //console.log('cancel', this.address, this.oldAddress);
        this.card = this.oldCard;
        this.newCard = new Card();
        localStorage.removeItem( 'editorId' );
        if ( this.editMode == 'E' ) {
            this.editMode = 'V';
        }
    }

    remove() {
        this.onDelete.emit( this.card );
    }

    confirmDialog( item: any ) {
        let dialogRef = this.dialog.open( ECMConfirmDialog, {
            width: '300px',
            height: '180px',
            disableClose: true
        });
        dialogRef.componentInstance.dialogTitle = "Remove Card ?";
        //dialogRef.componentInstance.confirmMsg = "Would you like to remove item from cart?";
        dialogRef.componentInstance.cancelText = "No";
        dialogRef.componentInstance.confirmText = "Yes";
        dialogRef.afterClosed().subscribe( result => {
            if ( result == 'true' ) {
                this.onDelete.emit( this.card );
            }
        });
    }

    simpleClone( obj: any ) {
        return Object.assign( {}, obj );
    }

//    setCardBank( cardNumber: string ) {
//        var lookup = require( 'binlookup' )();
//
//        console.log( 'cardNumber[' + cardNumber + ']' );
//
//        lookup( cardNumber ).then(
//            data => {
//                console.log( 'credit card details', data );
//                this.card.bankName = data.bank.name;
//            });
//    }

    setCardType( cardNumber ) {
        var lookup = require( 'binlookup' )();

        console.log( 'cardNumber[' + cardNumber + ']' );

        lookup( cardNumber ).then(
            data => {
                console.log( 'credit card details', data );
                if ( data.type == 'credit' ) {
                    this.newCard.payMthdType = '0';
                } else {
                    this.newCard.payMthdType = '1';
                }
                this.onAddNew.emit( this.newCard );
                this.reInitialize();
            });
    }

}
