import { Component, Input, Output, EventEmitter, ViewEncapsulation, OnInit, ElementRef,ViewChild  } from '@angular/core';
import { Address } from './address.model';
import { IScreenEditor } from '../screen-editor';

import { AddressScreenComponent } from './address-screen/address-screen.component';

@Component({
  selector: 'address-manager',
  templateUrl: './address-manager.component.html',
  styleUrls: ['./address-manager.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class AddressEditor implements OnInit, IScreenEditor {

    @Input() editorId : string;
    @Input() editMode : string = 'V';
    @Input() address : Address;

    @Output() onDelete : EventEmitter<Address>  = new EventEmitter<Address>();
    @Output() onAddNew : EventEmitter<Address>  = new EventEmitter<Address>();
    @Output() onSave : EventEmitter<Address>  = new EventEmitter<Address>();
    @Output() onDiscard : EventEmitter<string>  = new EventEmitter<string>();

    @ViewChild('addrAddScreen') addScreen: AddressScreenComponent;
    @ViewChild('addrEditScreen') editScreen: AddressScreenComponent;
    public addForm;
    public editForm;
    
    newAddress : Address;
    oldAddress : Address;
    showAdd : boolean = false;

    ngOnInit(){
        console.log("ID", this.editorId );
    }

    addNew(){
        if( this.checkEditorStatus() ) {
            this.newAddress = new Address();
            this.showAdd = true;
            localStorage.setItem('editorId', this.editorId );
        }
    }

    edit() {
        if( this.checkEditorStatus() ) {
            this.oldAddress = this.simpleClone( this.address );
            this.editMode = 'E';
            localStorage.setItem('editorId', this.editorId );
        }
    }

    save(){
        console.log('save', this.showAdd,  this.address, this.newAddress);
        if( this.showAdd ) {
            this.onAddNew.emit(this.newAddress);
        }
        else {
            this.onSave.emit(this.address);
        }
        console.log('save...');
        this.showAdd = false;
        this.newAddress = new Address();
        localStorage.removeItem('editorId');
        if( this.editMode == 'E'){
            this.editMode = 'V';
        }
    }

    cancel(){
        this.showAdd = false;
        //console.log('cancel', this.address, this.oldAddress);
        this.address = this.oldAddress;
        this.newAddress = new Address();
        localStorage.removeItem('editorId');
        if( this.editMode == 'E'){
            this.editMode = 'V';
        }
    }

    remove(){
        this.onDelete.emit(this.address);
    }

    simpleClone(obj: any) {
      return Object.assign({}, obj);
    }

    checkEditorStatus() : boolean {
        let cacheId = localStorage.getItem('editorId');
        if( cacheId ) {
            let choice = window.confirm("Discard current changes ?");
            console.log('choice', choice);
            if( choice ) {
                localStorage.removeItem('editorId');
                this.onDiscard.emit(cacheId);
                console.log('cacheId element >>' , cacheId);
            }
            return choice;
        }
        return true;
    }
        
    ngAfterViewChecked(): void {
        console.log("ngAfterViewChecked disable save button before")
        if ( this.showAdd ) {
            this.addForm = this.addScreen.addressForm;
            console.log("ngAfterViewChecked disable save button After", this.addForm ,  this.editForm);
       }
        
        if( this.editMode == 'E' ) {
            this.editForm = this.editScreen.addressForm;
            console.log("ngAfterViewChecked disable save button After", this.addForm ,  this.editForm);
        }

    }
}
