import { Component, OnInit } from '@angular/core';

import { EcmTrendProductService } from './ecm-trend-product.service';
import { ItemDetail } from '../../ecm-model/product-detail-model';

declare var reinitFlickity: any;

@Component({
  selector: 'ecm-trend-product',
  templateUrl: './ecm-trend-product.component.html',
  styleUrls: ['./ecm-trend-product.component.css'],
  providers: [EcmTrendProductService]
})
export class EcmTrendProductComponent implements OnInit {
    
    trendingItems: ItemDetail[];
    errorMessage: string;

    constructor(public trendingService: EcmTrendProductService) { }

    getTrends() {
        this.trendingService.getTrending().subscribe(
          trendingItems => {
            this.trendingItems = trendingItems;
            reinitFlickity();
            console.log('comp trendingItems[' +  JSON.stringify( trendingItems ) + '] \n this.trendingItems[' +  JSON.stringify( this.trendingItems ) + ']');
          },
          error =>  {
            this.errorMessage = <any>error;
            console.log('comp errorMessage[' + this.errorMessage + ']');
          });
    }
    
    ngOnInit() {
      this.getTrends();
    }
    
}
