import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
import {Store} from '@ngrx/store';
import { HostUrlService } from '../../host-url.service';

import { SubCategory } from '../../ecm-model/subcategory-model';

@Injectable()
export class EcmSubCategoryService {

  //   private SERVICE_URL = '/ecm/service/L2D01/category';  // URL to web service
    private SERVICE_URL = '/ecm/service';
    constructor (private http: Http,public hostUrlService : HostUrlService) {}


    getSubCategories( catCode: string ): Observable<SubCategory[]> {
        
        let siteCode = localStorage.getItem('SITE_CODE');  
        let subCategoriesUrl = this.hostUrlService.hostUrl+this.SERVICE_URL + '/' + siteCode + '/category' + '/' + catCode + '/list';
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });

        return this.http.get( subCategoriesUrl, options )
            .map( this.extractData )
            .catch( this.handleError );
    }

    getSubCategory (scatCode : string): Observable<SubCategory> {

      let siteCode = localStorage.getItem('SITE_CODE');   
      let subCategoryUrl = this.hostUrlService.hostUrl+this.SERVICE_URL + '/' + siteCode + '/category' + '/list/' + scatCode;
      let headers = new Headers({ 'Content-Type': 'application/json' });
      let options = new RequestOptions({ headers: headers });

      return this.http.get(subCategoryUrl, options)
                      .map(this.extractData)
                      .catch(this.handleError);
    }

    private extractData(res: Response) {
      let body = res.json();
      console.log('extractData[' + JSON.stringify(body) + ']');
      return body || { };
    }

    private handleError (error: Response | any) {
      // In a real world app, we might use a remote logging infrastructure
      let errMsg: string;
      if (error instanceof Response) {
        const body = error.json() || '';
        const err = body.error || JSON.stringify(body);
        errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
      } else {
        errMsg = error.message ? error.message : error.toString();
      }
      console.error('Service handleError:' + errMsg);
      return Observable.throw(errMsg);
    }

}
