import { Component, OnInit, Output, EventEmitter } from '@angular/core';
import { Router } from '@angular/router';

import { EcmRecentViewService } from './ecm-recent-view.service';
import { Item } from '../../ecm-model/product-model';
import { ItemDetail } from '../../ecm-model/product-detail-model';

@Component( {
    selector: 'ecm-recent-view',
    templateUrl: './ecm-recent-view.component.html',
    styleUrls: ['./ecm-recent-view.component.css'],
    providers: [EcmRecentViewService]
})
export class EcmRecentViewComponent implements OnInit {
    recentViewItems: Item[];
    errorMessage: string;
    show = 3;
    
    constructor( public recentviewService: EcmRecentViewService, private router: Router ) { }

    ngOnInit() {
        this.getRecentViewItems();
    }
    
    getRecentViewItems() {
        this.recentviewService.getRecentViewItems().subscribe(
            recentViewItems => {
                if(recentViewItems.length){
                    this.recentViewItems = recentViewItems.reverse();
                }
                console.log( 'comp recentItems',this.recentViewItems );
            },
            error => {
                this.errorMessage = <any>error;
                console.log( 'comp errorMessage[' + this.errorMessage + ']' );
            });
    }
    
    viewItem(itemCode){
        this.router.navigate(['/detail',itemCode]);
    }
    
    public doDestroy( itemCode: string ) {
        this.recentviewService.storeRecentViewItem( itemCode );
    }
}
