import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';


import {Profile} from '../../user-profile/profile-manager/profile.model';
import {ProfileActions} from '../actions';
import * as _ from 'lodash';

export type ProfileState = Profile;
const initialState: ProfileState = {
         id: 'ADDR_' + Math.random(),
         userName: '',
         firstName: '',
         lastName: '',
         emailId: '',
         contactNo: '',
         birthDate: '',
         gender: ''
}; 

export default function (state = initialState, action: Action): ProfileState {
    switch (action.type) {
    case ProfileActions.LOAD_USER_INFO_SUCCESS: {
        return action.payload;
    }
    case ProfileActions.UPDATE_USER_INFO_SUCCESS: {
        return action.payload;
    }
    default: {
        return state;
    }
  }
}