import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {Review} from '../../user-review/review-manager/review.model';


export class ReviewAction {
    
    static LOAD_REVIEWS = '[Reviews] Load Reviews';
    loadReviews(): Action {
        return {
            type: ReviewAction.LOAD_REVIEWS
        };
    }
    
    static LOAD_REVIEWS_SUCCESS = '[Reviews] Load Reviews Success';
    loadReviewsSuccess(userReview): Action {
        
//        if(!cartItems.length)
//        {
//            cartItems = [];
//        }
        return {
            type: ReviewAction.LOAD_REVIEWS_SUCCESS,
            payload: userReview
        };
        
    }
    
    static UPDATE_REVIEWS = '[Reviews] Update Reviews';
    updateReviews(userReview): Action {
        return {
            type: ReviewAction.UPDATE_REVIEWS,
            payload: userReview
        };
    }

    static UPDATE_REVIEWS_SUCCESS = '[Reviews] Update Reviews Success';
    updateReviewsSuccess(userReview): Action {
        return {
            type: ReviewAction.UPDATE_REVIEWS_SUCCESS,
            payload: userReview
        };
    }
    
    static DELETE_REVIEWS = '[Reviews] Delete Reviews';
    deleteReviews(userReview): Action {
        return {
            type: ReviewAction.DELETE_REVIEWS,
            payload: userReview
        };
    }

    static DELETE_REVIEWS_SUCCESS = '[Reviews] Delete ReviewsSuccess';
    deleteReviewsSuccess(userReview): Action {
        return {
            type: ReviewAction.DELETE_REVIEWS_SUCCESS,
            payload: userReview
        };
    }
    
    static RESET_REVIEWS = '[Reviews] Reset Reviews';
    resetReviews(): Action {
        return {
            type: ReviewAction.RESET_REVIEWS
        };
    }
    
}
