import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';

import { Reviews } from '../ecm-model/product-review.model';
import { HostUrlService } from '../host-url.service';

@Injectable()
export class EcmProductReviewService {
  
   
  constructor( public hostUrlService : HostUrlService,private http: Http) { }
  
  getReviews(solrUrl) {
      
      let headers = new Headers( { 'Content-Type': 'application/json' });
      let options = new RequestOptions( { headers: headers });
      
      return this.http.get( this.hostUrlService.hostUrl+solrUrl, options )
      .map( this.extractData )
      .catch( this.handleError );
      
  }
  
  updateLikes(itemCode, data) {
      let headers = new Headers( { 'Content-Type': 'application/json' });
      let options = new RequestOptions( { headers: headers });
      let siteCode = localStorage.getItem('SITE_CODE');
 //     let userServiceUrl = '/ecm/service/feeds/L2D01/update/likes/'+itemCode;
      let userServiceUrl = '/ecm/service/feeds';
      
      console.log("Inside Update Likes "+itemCode);
      console.log(JSON.stringify(data));
      
      this.http.post( this.hostUrlService.hostUrl+userServiceUrl + '/'+ siteCode + '/update' + '/likes' + '/' + itemCode , data, options)
      .subscribe(data => {
         console.log("Updated Likes");
      }, error => {
          console.log(error.json());
      }); 
  }
  
  submitReview(reviewData){
//      let userServiceUrl = '/ecm/service/feeds/L2D01/review';
      let userServiceUrl = '/ecm/service/feeds';
      let headers = new Headers( { 'Content-Type': 'application/json' });
      let options = new RequestOptions( { headers: headers });
      let siteCode = localStorage.getItem('SITE_CODE');
      
      console.log("Submitting Review...");
      console.log(JSON.stringify(reviewData));
      
      this.http.post( this.hostUrlService.hostUrl+userServiceUrl + '/'+ siteCode + '/review' , reviewData, options)
      .subscribe(data => {
         console.log("Add Review");
      }, error => {
          console.log(error.json());
      }); 
  }
  
  getUserReview(itemCode){
//      let getUserReviewUrl = '/ecm/service/feeds/L2D01/review/';
      let siteCode = localStorage.getItem('SITE_CODE');
      let getUserReviewUrl = '/ecm/service/feeds';
      getUserReviewUrl = getUserReviewUrl + '/'+ siteCode + '/review' + '/' + itemCode;
      console.log("URL: " +getUserReviewUrl);
      
      let headers = new Headers( { 'Content-Type': 'application/json' });
      let options = new RequestOptions( { headers: headers });
      
      return this.http.get( this.hostUrlService.hostUrl+ getUserReviewUrl, options )
      .map( this.extractData )
      .catch( this.handleError );
  }
  
  private extractData(res: Response) {
      let body = res.json();
      console.log('extractData[' + JSON.stringify(body) + ']');
      return body || { };
    }

    private handleError (error: Response | any) {
      // In a real world app, we might use a remote logging infrastructure
      let errMsg: string;
      if (error instanceof Response) {
        const body = error.json() || '';
        const err = body.error || JSON.stringify(body);
        errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
      } else {
        errMsg = error.message ? error.message : error.toString();
      }
      console.error('Service handleError:' + errMsg);
      return Observable.throw(errMsg);
    }
}
