/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.CompositeEnhancer;
import org.hibernate.bytecode.enhance.internal.EntityEnhancer;
import org.hibernate.bytecode.enhance.internal.FieldWriter;
import org.hibernate.bytecode.enhance.internal.MappedSuperclassEnhancer;
import org.hibernate.bytecode.enhance.internal.PersistentAttributesEnhancer;
import org.hibernate.bytecode.enhance.internal.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final EnhancementContext enhancementContext;
    private final ClassPool classPool;

    public Enhancer(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
        this.classPool = this.buildClassPool(enhancementContext);
    }

    public synchronized byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        try {
            CtClass managedCtClass = this.classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(originalBytes));
            this.enhance(managedCtClass);
            return this.getByteCode(managedCtClass);
        }
        catch (IOException e) {
            log.unableToBuildEnhancementMetamodel(className);
            return originalBytes;
        }
    }

    private ClassPool buildClassPool(final EnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false){

            public ClassLoader getClassLoader() {
                return enhancementContext.getLoadingClassLoader();
            }
        };
        ClassLoader loadingClassLoader = enhancementContext.getLoadingClassLoader();
        if (loadingClassLoader != null) {
            classPool.appendClassPath((ClassPath)new LoaderClassPath(loadingClassLoader));
        }
        return classPool;
    }

    protected CtClass loadCtClassFromClass(Class<?> aClass) {
        String resourceName = aClass.getName().replace('.', '/') + ".class";
        InputStream resourceAsStream = aClass.getClassLoader().getResourceAsStream(resourceName);
        try {
            CtClass ctClass = this.classPool.makeClass(resourceAsStream);
            return ctClass;
        }
        catch (IOException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
        finally {
            try {
                resourceAsStream.close();
            }
            catch (IOException ioe) {
                log.debugf("An error occurs closing InputStream for class [%s]", aClass.getName());
            }
        }
    }

    private void enhance(CtClass managedCtClass) {
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface!", managedCtClass.getName());
            return;
        }
        if (PersistentAttributesHelper.isAssignable(managedCtClass, Managed.class.getName())) {
            log.debugf("Skipping enhancement of [%s]: already enhanced", managedCtClass.getName());
            return;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            log.infof("Enhancing [%s] as Entity", managedCtClass.getName());
            new EntityEnhancer(this.enhancementContext).enhance(managedCtClass);
        } else if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            log.infof("Enhancing [%s] as Composite", managedCtClass.getName());
            new CompositeEnhancer(this.enhancementContext).enhance(managedCtClass);
        } else if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            log.infof("Enhancing [%s] as MappedSuperclass", managedCtClass.getName());
            new MappedSuperclassEnhancer(this.enhancementContext).enhance(managedCtClass);
        } else if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            log.infof("Extended enhancement of [%s]", managedCtClass.getName());
            new PersistentAttributesEnhancer(this.enhancementContext).extendedEnhancement(managedCtClass);
        } else {
            log.debugf("Skipping enhancement of [%s]: not entity or composite", managedCtClass.getName());
        }
    }

    private byte[] getByteCode(CtClass managedCtClass) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            managedCtClass.toBytecode(out);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.unableToTransformClass(e.getMessage());
            throw new HibernateException("Unable to transform class: " + e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void addInterceptorHandling(CtClass managedCtClass) {
        if (!this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            return;
        }
        log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", managedCtClass.getName());
        managedCtClass.addInterface(this.loadCtClassFromClass(PersistentAttributeInterceptable.class));
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.loadCtClassFromClass(PersistentAttributeInterceptor.class), "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
    }

    @Deprecated
    public byte[] enhanceComposite(String className, byte[] originalBytes) throws EnhancementException {
        return this.enhance(className, originalBytes);
    }
}

