/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.registry.ClusterRegistry;

@ThreadSafe
final class ReadIntensiveClusterRegistryWrapper<S, K, V> {
    private final ClusterRegistry<S, K, V> clusterRegistry;
    private final S scope;
    private final AtomicReference<Map<K, V>> localCache = new AtomicReference<Map>(Collections.EMPTY_MAP);

    ReadIntensiveClusterRegistryWrapper(ClusterRegistry<S, K, V> clusterRegistry, S scope) {
        this.clusterRegistry = clusterRegistry;
        this.scope = scope;
    }

    void addListener(Object registryListener) {
        this.clusterRegistry.addListener(this.scope, registryListener);
    }

    Set<K> keys() {
        return this.clusterRegistry.keys(this.scope);
    }

    void removeListener(Object registryListener) {
        this.clusterRegistry.removeListener(registryListener);
    }

    boolean containsKey(K key) {
        return this.localCache.get().containsKey(key);
    }

    void put(K key, V value) {
        this.clusterRegistry.put(this.scope, key, value);
        this.localCacheInsert(key, value);
    }

    V get(K key) {
        return this.localCache.get().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localCacheInsert(K key, V value) {
        AtomicReference<Map<K, V>> atomicReference = this.localCache;
        synchronized (atomicReference) {
            Map<K, V> currentContent = this.localCache.get();
            int currentSize = currentContent.size();
            if (currentSize == 0) {
                this.localCache.lazySet(Collections.singletonMap(key, value));
            } else {
                HashMap<K, V> updatedContent = new HashMap<K, V>(currentSize + 1);
                updatedContent.putAll(currentContent);
                updatedContent.put(key, value);
                this.localCache.lazySet(Collections.unmodifiableMap(updatedContent));
            }
        }
    }
}

