/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateful;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.proxy.JndiSessionProxyObjectFactory;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.proxy.factory.BaseSessionProxyFactory;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public abstract class BaseStatefulProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatefulProxyFactory.class);
    public static final String PROXY_FACTORY_NAME = "StatefulProxyFactory";

    protected BaseStatefulProxyFactory() {
    }

    public BaseStatefulProxyFactory(SessionSpecContainer container, String jndiName) {
        super(container);
        assert (jndiName != null) : "jndiName is null";
        this.jndiName = jndiName;
    }

    public void init() throws Exception {
        this.validateEjb21Views();
        this.createProxyConstructors();
    }

    public void start() throws Exception {
        this.init();
        InitialContext ctx = this.getContainer().getInitialContext();
        String jndiName = this.getJndiName();
        StringRefAddr refAddr = new StringRefAddr("FACTORY", jndiName + PROXY_FACTORY_NAME);
        Reference ref = new Reference(Object.class.getName(), refAddr, JndiSessionProxyObjectFactory.class.getName(), null);
        this.bindProxy(ref);
    }

    public void stop() throws Exception {
        String jndiName = this.getJndiName();
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)jndiName);
    }

    protected final void initializeJndiName() {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.init();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }
}

