/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class IntFieldAsByteLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private FieldCache.Ints currentCache;

    public IntFieldAsByteLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(AtomicReaderContext context) throws IOException {
        AtomicReader reader = context.reader();
        this.currentCache = FieldCache.DEFAULT.getInts(reader, this.fieldName, false);
    }

    @Override
    public Byte collect(int relativeDocId) {
        return (byte)this.currentCache.get(relativeDocId);
    }
}

