/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneBackendTaskStreamer {
    private static final Log log = LoggerFactory.make();
    private final LuceneBackendResources resources;
    private final Lock modificationLock;
    private final AbstractWorkspaceImpl workspace;

    public LuceneBackendTaskStreamer(LuceneBackendResources resources) {
        this.workspace = resources.getWorkspace();
        this.modificationLock = resources.getParallelModificationLock();
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(LuceneWork work, IndexingMonitor monitor) {
        this.modificationLock.lock();
        try {
            IndexWriter indexWriter = this.workspace.getIndexWriter();
            if (indexWriter == null) {
                log.cannotOpenIndexWriterCausePreviousError();
                return;
            }
            boolean errors = true;
            try {
                work.getWorkDelegate(this.resources.getVisitor()).performWork(work, indexWriter, monitor);
                errors = false;
            }
            finally {
                this.workspace.afterTransactionApplied(errors, true);
            }
        }
        finally {
            this.modificationLock.unlock();
        }
    }
}

