/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkOperation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZkCmdExecutor {
    private long retryDelay = 1500L;
    private int retryCount;
    private double timeouts;

    public ZkCmdExecutor(int timeoutms) {
        this.timeouts = (double)timeoutms / 1000.0;
        this.retryCount = Math.round(0.5f * ((float)Math.sqrt(8.0 * this.timeouts + 1.0) - 1.0f)) + 1;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public <T> T retryOperation(ZkOperation operation) throws KeeperException, InterruptedException {
        KeeperException.ConnectionLossException exception = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return (T)operation.execute();
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedException();
                }
                if (Thread.currentThread() instanceof ClosableThread && ((ClosableThread)((Object)Thread.currentThread())).isClosed()) {
                    throw exception;
                }
                if (i == this.retryCount - 1) continue;
                this.retryDelay(i);
                continue;
            }
        }
        throw exception;
    }

    public void ensureExists(String path, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        this.ensureExists(path, null, CreateMode.PERSISTENT, zkClient);
    }

    public void ensureExists(String path, byte[] data, CreateMode createMode, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        if (zkClient.exists(path, true).booleanValue()) {
            return;
        }
        try {
            zkClient.makePath(path, data, createMode, true);
        }
        catch (KeeperException.NodeExistsException e) {
            // empty catch block
        }
    }

    protected void retryDelay(int attemptCount) throws InterruptedException {
        Thread.sleep((long)(attemptCount + 1) * this.retryDelay);
    }
}

