/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractCustomInterceptorsConfigurationChildBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InterceptorConfigurationBuilder
extends AbstractCustomInterceptorsConfigurationChildBuilder
implements Builder<InterceptorConfiguration> {
    private static final Log log = LogFactory.getLog(InterceptorConfigurationBuilder.class);
    private Class<? extends CommandInterceptor> after;
    private Class<? extends CommandInterceptor> before;
    private CommandInterceptor interceptor;
    private int index = -1;
    private InterceptorConfiguration.Position position = InterceptorConfiguration.Position.OTHER_THAN_FIRST_OR_LAST;
    private Properties properties = new Properties();

    InterceptorConfigurationBuilder(CustomInterceptorsConfigurationBuilder builder) {
        super(builder);
    }

    public InterceptorConfigurationBuilder after(Class<? extends CommandInterceptor> after) {
        this.after = after;
        return this;
    }

    public InterceptorConfigurationBuilder before(Class<? extends CommandInterceptor> before) {
        this.before = before;
        return this;
    }

    public InterceptorConfigurationBuilder interceptor(CommandInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public InterceptorConfigurationBuilder index(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Index cannot be negative");
        }
        this.index = i;
        return this;
    }

    public InterceptorConfigurationBuilder position(InterceptorConfiguration.Position p) {
        this.position = p;
        return this;
    }

    public InterceptorConfigurationBuilder withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public InterceptorConfigurationBuilder clearProperties() {
        this.properties = new Properties();
        return this;
    }

    public InterceptorConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public InterceptorConfigurationBuilder removeProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    public void validate() {
        String className;
        int positions = 0;
        if (this.before != null) {
            ++positions;
        }
        if (this.after != null) {
            ++positions;
        }
        if (this.index > -1) {
            ++positions;
        }
        if (!this.position.equals((Object)InterceptorConfiguration.Position.OTHER_THAN_FIRST_OR_LAST)) {
            ++positions;
        }
        switch (positions) {
            case 0: {
                throw log.missingCustomInterceptorPosition(this.interceptor.getClass().getName());
            }
            case 1: {
                break;
            }
            default: {
                throw log.multipleCustomInterceptorPositions(this.interceptor.getClass().getName());
            }
        }
        if (this.interceptor == null) {
            throw log.customInterceptorMissingClass();
        }
        if (!(this.interceptor instanceof BaseCustomInterceptor) && !(className = this.interceptor.getClass().getName()).startsWith("org.infinispan.")) {
            log.suggestCustomInterceptorInheritance(className);
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public InterceptorConfiguration create() {
        return new InterceptorConfiguration(this.after, this.before, this.interceptor, this.index, this.position, TypedProperties.toTypedProperties((Properties)this.properties));
    }

    public InterceptorConfigurationBuilder read(InterceptorConfiguration template) {
        this.after = template.after();
        this.before = template.before();
        this.index = template.index();
        this.interceptor = template.interceptor();
        this.position = template.position();
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)template.properties());
        return this;
    }

    public String toString() {
        return "InterceptorConfigurationBuilder [after=" + this.after + ", before=" + this.before + ", interceptor=" + this.interceptor + ", index=" + this.index + ", position=" + (Object)((Object)this.position) + ", properties=" + this.properties + "]";
    }
}

