/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Index;

public class IndexingConfiguration
extends AbstractTypedPropertiesConfiguration {
    private final Index index;
    private final boolean autoConfig;
    private static final String DIRECTORY_PROVIDER_KEY = "directory_provider";
    private static final String RAM_DIRECTORY_PROVIDER = "ram";

    IndexingConfiguration(TypedProperties properties, Index index, boolean autoConfig) {
        super(properties);
        this.index = index;
        this.autoConfig = autoConfig;
    }

    @Deprecated
    public boolean enabled() {
        return this.index.isEnabled();
    }

    @Deprecated
    public boolean indexLocalOnly() {
        return this.index.isLocalOnly();
    }

    public TypedProperties properties() {
        return super.properties();
    }

    public Index index() {
        return this.index;
    }

    public boolean autoConfig() {
        return this.autoConfig;
    }

    public boolean indexShareable() {
        TypedProperties properties = this.properties();
        boolean hasRamDirectoryProvider = false;
        for (Object objKey : properties.keySet()) {
            String key = (String)objKey;
            if (!key.endsWith(DIRECTORY_PROVIDER_KEY)) continue;
            if (properties.get((Object)key).equals(RAM_DIRECTORY_PROVIDER)) {
                hasRamDirectoryProvider = true;
                continue;
            }
            return true;
        }
        return !hasRamDirectoryProvider;
    }

    public String toString() {
        return "IndexingConfiguration{index=" + (Object)((Object)this.index) + ", properties=" + this.properties() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexingConfiguration that = (IndexingConfiguration)((Object)o);
        if (this.index != that.index) {
            return false;
        }
        return this.autoConfig == that.autoConfig;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.autoConfig ? 1 : 0);
        return result;
    }
}

