<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">
	<html>
		<head>
			<style type="text/css">
				.tTitle1
				{
				text-align:center;
				}
				.tHeaderD1
				{
				text-align:right;
				}
				.tTitleD1
				{
				text-align:center;
				}
				.numberData
				{
				text-align:right;
				}
				.editDisplayClass
				{readOnly:true;border :inset 1;COLOR:BLACK ;BACKGROUND:#FFFFD9; TEXT-ALIGN:left;FONT:
				8ptarial; width:auto;};
				.editDisplayRemarkClass
				{readOnly:true;border :inset 1;COLOR:black ; BACKGROUND:#FFFFD9; TEXT-ALIGN:left;FONT:
				7ptarial;};
				.editDisplayrightClass
				{readOnly:true;border :inset 1;COLOR:black ; TEXT-ALIGN:right;FONT:8ptarial;};
				.editDisplayecnterClass
				{readOnly:true;border :inset 1;COLOR:white ;
				BACKGROUND:#5b7290;TEXT-ALIGN:center;FONT:8ptarial;};
				.displayCenterClass
				{readOnly:true;border :inset 1;COLOR:#DC143C;
				BACKGROUND:#CCCCFF;TEXT-ALIGN:center;FONT:10ptarial;};
				.displayCenterClass2
				{readOnly:true;border :inset 1;COLOR:#0000CD;
				BACKGROUND:#E0FFFF;TEXT-ALIGN:center;FONT:10ptarial;};
				.editDisplayColumnClass{readOnly:true;color:#555; TEXT-ALIGN:left;
				padding:5px; font-size:16px; font-weight:normal;}
				.editDisplayheaderClass{readOnly:true;color:#000; TEXT-ALIGN:left;
				padding:5px; font-weight:normal; font-size:14px;
				vertical-align:top;}
				.editDisplayrightClass{readOnly:true;border :inset 1;COLOR:black ; BACKGROUND:#FFFFD9;TEXT-ALIGN:right;
				font-weight:normal;}
				.editDisplayecnterClass{readOnly:true; color:#5fdeb2; TEXT-ALIGN:left; font-size:18px; padding:5px 0;
				font-weight:normal;}
				.editDisplayecnterClass2{readOnly:true;border :inset 1;COLOR:black ; TEXT-ALIGN:center; font-weight:normal;}
				.editDisplayClass{background-color: transparent
				!important;readOnly:true;color:#555; TEXT-ALIGN:left; padding:5px;
				font-weight:normal; font-size:14px;}
				.editDisplayecnterClass1 {readOnly:true; color:#5fdeb2; TEXT-ALIGN:left; font-size:16px;
				padding:10px 0 0 0;}
				.editDisplayecnterClass3 {readOnly:true; color:#5fdeb2; TEXT-ALIGN:left; font-size:16px;
				padding:10px 0 0 0;}
				.tableClass {margin-bottom:10px; width:100%; background-color:#FFF;
				/*padding:10px;*/ border-left: 1px solid #d9d9d9; border-top: 1px
				solid #d9d9d9;}
				.tableClass td {border-bottom: 1px solid #d9d9d9; border-right: 1px solid
				#d9d9d9; font-size:14px;}
				.tbletopbrd{border-top:2px solid #5fdeb2;}
				.date {
				color: #9d9ca2;
				font-size: 11px;
				font-weight: normal;
				}
				.tableClass1 {
				margin-bottom: 5px;
				width: 100%;
				background-color: #FFF;
				border-LEFT: 1px solid #d9d9d9;
				border-top: 1px solid #d9d9d9;
				}
				.tableClass1 td {
				border-bottom: 1px solid #d9d9d9;
				border-right: 1px solid #d9d9d9;
				font-size: 14px;
				line-height: 18px;
				padding: 5px;
				}
		</style>
		</head>
		<body>
			<input type="hidden" value="salesreturn_retn" name="OBJ_NAME" id="OBJ_NAME" />
			<input type="hidden" value="2" name="PAGE_CONTEXT" id="PAGE_CONTEXT" />
			<input type="hidden" value="1" name="OBJ_CONTEXT" id="OBJ_CONTEXT" />
			<form name="SalesReturn">
				<table cellSpacing="0" cellPadding="0" width="100%" border="0">
							<tbody>
								<tr>
									<td colSpan="4" class="editDisplayColumnClass">
										<font size="4">
											Sales Return
										</font>
									</td>
								</tr>
							</tbody>
					</table>
					<xsl:for-each select="//Detail1">
						<table class="tableClass tbletopbrd" cellSpacing="0" cellPadding="0" width="100%" border="0">
							<TBODY>
								<xsl:variable name="dbID">
									<xsl:value-of select="@dbID" />
								</xsl:variable>
								<xsl:variable name="wf_status">
									<xsl:value-of select="wf_status" />
								</xsl:variable>
								<xsl:variable name="tran_id">
									<xsl:value-of select="tran_id" />
								</xsl:variable>
								<xsl:variable name="tran_date">
									<xsl:value-of select="tran_date" />
								</xsl:variable>
								<xsl:variable name="claim_date">
									<xsl:value-of select="claim_date" />
								</xsl:variable>
								<xsl:variable name="item_code">
									<xsl:value-of select="item_code" />
								</xsl:variable>
								<xsl:variable name="descr">
									<xsl:value-of select="descr" />
								</xsl:variable>
								<xsl:variable name="reas_code">
									<xsl:value-of select="reas_code" />
								</xsl:variable>
								<xsl:variable name="reason_descr">
									<xsl:value-of select="reason_descr" />
								</xsl:variable>
								<xsl:variable name="item_ser">
									<xsl:value-of select="item_ser" />
								</xsl:variable>
								<xsl:variable name="itemser_descr">
									<xsl:value-of select="itemser_descr" />
								</xsl:variable>
								<xsl:variable name="cust_code">
									<xsl:value-of select="cust_code" />
								</xsl:variable>
								<xsl:variable name="cust_name">
									<xsl:value-of select="cust_name" />
								</xsl:variable>
								<xsl:variable name="site_code">
									<xsl:value-of select="site_code" />
								</xsl:variable>
								<xsl:variable name="site_descr">
									<xsl:value-of select="site_descr" />
								</xsl:variable>
								<xsl:variable name="invoice_id">
									<xsl:value-of select="invoice_id" />
								</xsl:variable>
								<xsl:variable name="cust_code__dlv">
									<xsl:value-of select="cust_code__dlv" />
								</xsl:variable>
								<xsl:variable name="cust_name__dlv">
									<xsl:value-of select="cust_name__dlv" />
								</xsl:variable>
								<xsl:variable name="ret_opt">
									<xsl:value-of select="ret_opt" />
								</xsl:variable>
								<xsl:variable name="full_ret">
									<xsl:value-of select="full_ret" />
								</xsl:variable>
								<xsl:variable name="ret_ref">
									<xsl:value-of select="ret_ref" />
								</xsl:variable>
								<xsl:variable name="site_code__dlv">
									<xsl:value-of select="site_code__dlv" />
								</xsl:variable>
								<xsl:variable name="dlv_location">
									<xsl:value-of select="dlv_location" />
								</xsl:variable>
								<xsl:variable name="remarks">
									<xsl:value-of select="remarks" />
								</xsl:variable>
								<xsl:variable name="process_fee">
									<xsl:value-of select="process_fee" />
								</xsl:variable>
								<TR>
									<td class="editDisplayClass" width="50%">
										<font face="Times New Roman">
											<font size="2">
												<strong>Ref. Invoice Id : </strong>
											</font>
											<font size="2">
												<xsl:choose>
											<xsl:when test="normalize-space($invoice_id)= ''">
												NA
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="invoice_id" />
											</xsl:otherwise>
										</xsl:choose>
											</font>
										</font>
									</td>
									<td class="editDisplayClass" style="text-align: right;" width="50%">
										<font face="Times New Roman">
											<font size="2">
												<b>Claim Date : </b>
												<xsl:value-of select="claim_date" />
											</font>
										</font>
									</td>
								</TR>
								<tr>
									<td class="editDisplayheaderClass"
										style="text-align: center;font-size: 18px;border: 0px;padding-bottom: 0px;"	colspan="2">
										Sales Return No :
										<xsl:value-of select="tran_id" />
									</td>
								</tr>
								<tr>
									<td class="date" style="text-align: center;border: 0px;padding-top: 0px;" width="100%" colspan="2">
										<xsl:value-of select="tran_date"/>
									</td>
								</tr>
								<tr>
								<td class="editDisplayClass">
									<font size="2">
										<strong>Site : </strong>
											<xsl:value-of select="site_code" />
									</font>
								</td>
								<td class="editDisplayClass" style="text-align: right;">
									<font size="2">
										<strong>Item Series : </strong>&#160;<xsl:value-of select="item_ser" />
									</font>
								</td>
								</tr>
								<tr>
									<td class="editDisplayClass" colspan = "2">
										<font size="2"><strong>Customer : </strong>
											<xsl:value-of select="cust_code"/>
											<!--, <xsl:value-of select="cust_name" />-->
										</font>
									</td>
								</tr>
							</TBODY>
						</table>
						<br></br>
								<table class="tableClass" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<tbody>
										<tr border="1">
										<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Return Type</font>
										</td>
										<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Adj Misc Crn</font>
										</td>
										<td class="editDisplayheaderClass">
												<font face="Times New Roman" size="2">Delivery Site</font>
										</td>
										<td class="editDisplayheaderClass">
												<font face="Times New Roman" size="2">Cust Reference</font>
										</td>
										<td class="editDisplayheaderClass">
												<font face="Times New Roman" size="2">Full Return</font>
										</td>
										<td class="editDisplayheaderClass">
												<font face="Times New Roman" size="2">Return Option</font>
										</td>
										<td class="editDisplayheaderClass">
												<font face="Times New Roman" size="2">Net Amount</font>
										</td>
									</tr>
									<tr>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:value-of select="tran_type" />
											</font>
										</td>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:value-of select="adj_misc_crn" />
											</font>
										</td>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:value-of select="site_code__dlv" />
											</font>
										</td>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:value-of select="cust_ref" />
											</font>
										</td>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:if test="full_ret='Y'">
													<label>Yes</label>
												</xsl:if>
												<xsl:if test="full_ret='N'">
													<label>No</label>
												</xsl:if>
											</font>
										</td>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:if test="ret_opt='R'">
													<label>Replaced</label>
												</xsl:if>
												<xsl:if test="ret_opt='C'">
													<label>Credit Note</label>
												</xsl:if>
												<xsl:if test="ret_opt='D'">
													<label>Debit Note (Replacement)</label>
												</xsl:if>
											</font>
										</td>
										<td class="editDisplayColumnClass" style="padding: 5px;color:#555;">
											<font face="Times New Roman" size="2">
												<xsl:value-of select="format-number(net_amt,'#####0.00')" />
											</font>
										</td>
									</tr>
									<tr>
										<td class="editDisplayheaderClass" colSpan="3" width="1%" style="text-align: left;font-size: 18px;">
											<font face="Times New Roman" size="2">
												Customer Bill:
												<xsl:value-of select="cust_code__bill" />
											</font>
										</td>
										<td class="editDisplayheaderClass" colSpan="4" width="1%" style="text-align: left;font-size: 18px;">
											<font face="Times New Roman" size="2">
												Customer Dlv:
												<xsl:value-of select="cust_code__dlv" />,
												&#160;
												<xsl:value-of select="cust_name__dlv" />
											</font>
										</td>
									</tr>
									<tr>
										<td class="editDisplayheaderClass" colSpan="3" width="1%" style="text-align: left;font-size: 18px;">
											<font face="Times New Roman" size="2">
												Reason Code :
												<xsl:value-of select="reas_code" />&#160;
												<xsl:value-of select="reason_descr" />
											</font>
										</td>
										<td class="editDisplayheaderClass" colSpan="4" width="1%" style="text-align: left;font-size: 18px;">
											<font face="Times New Roman" size="2">
												Return Reference :
												<xsl:value-of select="ret_ref" />
											</font>
										</td>
									</tr>
									<tr>
										<td class="editDisplayRemarkClass" style = "padding: 5px;" colspan = "8">
											<font face="Times New Roman">
												<font size="2">Remarks: <xsl:value-of select="remarks"/></font>
											</font>
										</td>
									</tr>
								</tbody>
							</table>
					</xsl:for-each>
					<br />
					<table width="100%" border="0" cellspacing="0" cellpadding="0">
						<tr>
							<td class="editDisplayheaderClass" width="1%">
								Sales Return Details
							</td>
						</tr>
					</table>
					<table class="tableClass" cellSpacing="0" cellPadding="0" width="100%" border="0">
						<tbody>
							<xsl:for-each select="//Detail1">
								<tr border="1">
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Sr No</font>
									</td>
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Item Code</font>
									</td>
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Description </font>
									</td>
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Unit 
										</font>
									</td>
									<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Quantity</font>
									</td>
									<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Rate
											</font>
									</td>
									<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Amount 
											</font>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:for-each select="//Detail2">
							<xsl:sort select="item_code" />
								<xsl:variable name="dbID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									<xsl:variable name="line_no">
										<xsl:value-of select="line_no" />
									</xsl:variable>
									<xsl:variable name="line_no__inv">
										<xsl:value-of select="line_no__inv" />
									</xsl:variable>
									<xsl:variable name="invoice_id">
										<xsl:value-of select="invoice_id" />
									</xsl:variable>
									<xsl:variable name="item_code">
										<xsl:value-of select="item_code" />
									</xsl:variable>
									<xsl:variable name="item_descr">
										<xsl:value-of select="item_descr" />
									</xsl:variable>
									<xsl:variable name="quantity">
										<xsl:value-of select="quantity" />
									</xsl:variable>
									<xsl:variable name="rate">
										<xsl:value-of select="rate" />
									</xsl:variable>
									<xsl:variable name="rate__clg">
										<xsl:value-of select="rate__clg" />
									</xsl:variable>
									<xsl:variable name="pre_item_code">
										<xsl:value-of select="preceding-sibling::Detail2[1]/item_code" />
									</xsl:variable>
								<tr>
									<td class="editDisplayColumnClass" style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="line_no"/>
										</font>
									</td>
									<td class="editDisplayColumnClass" style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="item_code"/>
										</font>
									</td>
									<td class="editDisplayColumnClass" style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="item_descr"/>
										</font>
									</td>
									<td class="editDisplayColumnClass" style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="unit"/>
										</font>
									</td>
									<td class="editDisplayColumnClass"  style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="quantity"/>
										</font>
									</td>
									<td class="editDisplayColumnClass"  style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="rate"/>
										</font>
									</td>
									<td class="editDisplayColumnClass"  style = "padding: 5px;color:#555;">
										<font face="Times New Roman" size="2">
											<xsl:value-of select="format-number(net_amt, '##,###,###,###,###')"/>
										</font>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
			</form>
		</body>
	</html>
</xsl:template>
</xsl:stylesheet>