<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<link rel="stylesheet" href="/ibase/webitm/css/DD/default.css" type="text/css" />
<link id="userThemeLink" type="text/css" rel="stylesheet" href=""/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>

<script language="JavaScript" type="text/javascript">
<![CDATA[
	$(function() {
	
		selectedCode = [];
		
		for( dbID = 1; dbID <= maxId; dbID++)
		{
			document.getElementById("DetailITCode."+ dbID +".selectbox").disabled = false;
			
			objCurr = document.getElementById("DetailITCode."+ dbID +".selectbox");
			
			if( objCurr.value == 'true' )
			{
				if ($.inArray( dbID, selectedCode ))
				{
					selectedCode.push( dbID );
				}
			}
		}
	});
]]>
</script>

<body>

<form name="Wizard_Team">
	
	<table id = "Details" class="headertableClass" border="0" cellspacing="1" cellpadding="1">
		
		<tr>
			<th class="tHeader" nowrap="true" width="5%">
				<!-- <input type="checkbox" id="chkAll" onclick="return checkAllPopup(this)"/> -->
			</th>
			<th class="tHeader" nowrap="true" valign="bottom" width="50%">
				<strong>Customer Name</strong>
			</th>
			<th class="tHeader" nowrap="true" valign="bottom" width="75%">
				<strong>Telephone</strong>
			</th>	
			<th class="tHeader" nowrap="true" valign="bottom" width="20%">
				<strong>Customer Code</strong>
			</th>
		</tr>
		
		<xsl:for-each select="//List">
			<xsl:variable name="fieldId"><xsl:value-of select="fieldId"/></xsl:variable>
			<xsl:variable name="fieldValue"><xsl:value-of select="fieldValue"/></xsl:variable>
			<xsl:variable name="otherField"><xsl:value-of select="otherField"/></xsl:variable>
			<xsl:variable name="tele1"><xsl:value-of select="tele1"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<SCRIPT>
				<![CDATA[ var qtyR; qtyR ="]]>	<xsl:value-of select="$dbID"/>
				<![CDATA[";maxId= qtyR; ]]>
			</SCRIPT>
			
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<tr class="trClass"  width="100%" id="{normalize-space($dbID)}" onclick="setCheckedRow(event, this)" ondblclick="setDoubleClickData(event, this)">
				<td>
					<xsl:choose>
						<xsl:when test="$chkbox ='Y'">
							<input type="checkbox" name="selectbox" id="DetailITCode.{normalize-space($dbID)}.selectbox" checked='true' value="true" disabled = "true" onClick="setCheckedPopup(this)"/>
						</xsl:when>	
						<xsl:otherwise>
							<input type="checkbox" name="selectbox" id="DetailITCode.{normalize-space($dbID)}.selectbox" value="false" disabled = "true" onClick="setCheckedPopup(this)"/>
						</xsl:otherwise>
					</xsl:choose>	
				</td>
				
				<td id="{normalize-space($dbID)}"  class="td_leftAlign" nowrap="true">
					<xsl:value-of select="fieldValue"/>
				</td>
				<td id="{normalize-space($dbID)}"  class="td_leftAlign" nowrap="true">
					<xsl:value-of select="tele1"/>
				</td>
				<td id="{normalize-space($dbID)}"  class="td_leftAlign" nowrap="true">
					<xsl:value-of select="fieldId"/>
				</td>
						
			</tr>
			<input type="hidden" name="Detail3.{normalize-space($dbID)}.fieldValue" id="DetailITCode.{normalize-space($dbID)}.fieldValue" 
					value="{normalize-space($fieldValue)}" />
			<input type="hidden" name="Detail3.{normalize-space($dbID)}.fieldId" id="DetailITCode.{normalize-space($dbID)}.fieldId" 
					value="{normalize-space($fieldId)}" />
			<input type="hidden" name="Detail3.{normalize-space($dbID)}.otherField" id="DetailITCode.{normalize-space($dbID)}.otherField" 
					value="{normalize-space($otherField)}" />
		</xsl:for-each>
</table>
</form>

</body>
</html>
</xsl:template>
</xsl:stylesheet>
