<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			</head>

			<script type="text/javascript" src="/ibase/webitm/js/MRPWizard.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    var maxCnt=0;
    function resetOrderOfVisit(obj)
    {
	for(cnt=1;cnt <=maxId;cnt++)
	{
		var selBoxID ="Detail2."+cnt+"."+ "selectbox";
		var visitOrderID ="Detail2."+cnt+"."+ "order_of_visit";
		if ( document.getElementById(selBoxID) != null && document.getElementById(selBoxID).value=='true' )
		{
			document.getElementById(selBoxID).value = false;
			document.getElementById(selBoxID).checked = false;
			
			if(document.getElementById(visitOrderID) != null)
			{
			      document.getElementById(visitOrderID).value = "";
			}
		}
		
	}
	orderVisit = 0;
    }
    
   

]]>

			</script>
			<body>


				<style type="text/css">

					.tableClass
					{margin-left:10px;margin-top:10px}

					.tableClass_rep
					{margin-left:0px}

					.header_td
					{border:inset
					0;background:#FFCCCC;font-family:verdana;font-size:9pt}

					.reset
					{border:inset 1;font-family:verdana;font-size:9pt;
					font-weight:bold}

					.input_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.td_leftAlign1
					{text-align:left;font-family:verdana;font-size:9pt}

					.tr_color
					{background:#B7E5F9}

					.hide
					{display:none }

					.Stock
					{background:#D7A5F9}

					.Planned
					{background:#D9D5F9}

					.WIP
					{background:#AAD5F9}

					.StockPlanned
					{background:#B7D5F9}

					.StockWIP
					{background:#A7B5F9}

					.PlannedWIP
					{background:#B7G5F9}

					.StockPlannedWIP
					{background:#ACD5F9}

				</style>

				<!-- form name = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" 
					onSubmit="javascript:return validatePlace('3');" -->
				<!-- form name = "mrp_run_wiz" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" -->
				<form name="mrp_run_wiz" METHOD="post"
					ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validatePlace('3');">
					<table id="travelTable" width="90%" class="tableClass"
						border="0" cellspacing="1" cellpadding="1">

						<xsl:for-each select="//Detail2">
							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>
							<SCRIPT>
				<![CDATA[ 
				var detCnt ;  
				detCnt ="]]><xsl:value-of select="$dbID" /><![CDATA[";
					maxId= detCnt; 												
				]]>
							</SCRIPT>

						</xsl:for-each>
						<tr>
							<td width="1%" class="header_td" nowrap="true" valign="bottom">
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Item Details Info</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Mfg Type</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>sales Order</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Line No.</strong>
							</td>
							
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Demand</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Others</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Gross</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Available</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Net Required</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Site Code</strong>
							</td>

							<!-- added by cpatil on 12/05/14 start -->
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Bom Code</strong>
							</td>
							<!-- added by cpatil on 12/05/14 start -->

							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Item Code</strong>
							</td>
							<td width="15%" class="header_td" nowrap="true" valign="bottom">
								<strong>Item Description</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Qty Required</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Unit</strong>
							</td>

							<!-- added by cpatil on 01/12/14 start -->
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Parent Bom Code</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Due date</strong>
							</td>
							<!-- added by cpatil on 01/12/14 end -->

							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Availability Source</strong>
							</td>

						</tr>
						<!--  <xsl:for-each select="//argmentdatainfo"> <xsl:variable name="dbID"> 
							<xsl:value-of select="@domID" /> </xsl:variable> <xsl:variable name="dateFr_argdata"><xsl:value-of 
							select="dateFr_argdata"/></xsl:variable> <xsl:variable name="dateTo_argdata"><xsl:value-of 
							select="dateTo_argdata"/></xsl:variable> <xsl:variable name="siteCodeFr_argdata"><xsl:value-of 
							select="siteCodeFr_argdata"/></xsl:variable> <xsl:variable name="siteCodeTo_argdata"><xsl:value-of 
							select="siteCodeTo_argdata"/></xsl:variable> <input type="hidden" name="Detail2.{normalize-space($dbID)}.dateFr_argdata" 
							id="Detail2.dateFr_argdata" value="{$dateFr_argdata}" size="10" ISCHANGED="false"/> 
							<input type="hidden" name="Detail2.{normalize-space($dbID)}.dateTo_argdata" 
							id="Detail2.dateTo_argdata" value="{$dateTo_argdata}" size="10" ISCHANGED="false"/> 
							<input type="hidden" name="Detail2.{normalize-space($dbID)}.siteCodeFr_argdata" 
							id="Detail2.siteCodeFr_argdata" value="{$siteCodeFr_argdata}" size="5" ISCHANGED="false"/> 
							<input type="hidden" name="Detail2.{normalize-space($dbID)}.siteCodeTo_argdata" 
							id="Detail2.siteCodeTo_argdata" value="{$siteCodeTo_argdata}" size="5" ISCHANGED="false"/> 
							</xsl:for-each> -->

						<!-- <xsl:for-each select="//Detail2/reference/order"> -->
						<xsl:for-each select="//Detail2">
						
							<xsl:sort select="sale_order" order="descending" />
							<xsl:sort select="itemType" />
							
							<!-- 
							<xsl:sort select="sale_order" />
							<xsl:sort select="line_no" />
							<xsl:sort select="item_code" />  
							 -->					
							
							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>
							<xsl:variable name="chkbox">
								<xsl:value-of select="@selected" />
							</xsl:variable>

							<xsl:variable name="itemDetailsInfo" select="itemDetailsInfo" />
							<xsl:variable name="sale_order" select="sale_order" />
							<xsl:variable name="line_no" select="line_no" />
							<xsl:variable name="qty_reqd">
								<xsl:value-of select="qty_reqd" />
							</xsl:variable>
							<xsl:variable name="item_code">
								<xsl:value-of select="item_code" />
							</xsl:variable>

							<xsl:variable name="item_code_sort">
								<xsl:value-of select="item_code" />
							</xsl:variable>

							<xsl:variable name="item_code_descr">
								<xsl:value-of select="item_code_descr" />
							</xsl:variable>
							<xsl:variable name="site_code">
								<xsl:value-of select="site_code" />
							</xsl:variable>

							<!-- added by cpatil on 12/05/14 start -->

							<xsl:variable name="bom_code_parent">
								<xsl:value-of select="bom_code_parent" />
							</xsl:variable>
							<xsl:variable name="bom_code_ref">
								<xsl:value-of select="bom_code_ref" />
							</xsl:variable>
							<xsl:variable name="bom_code_org">
								<xsl:value-of select="bom_code_org" />
							</xsl:variable>
							<xsl:variable name="itemCodeDetailMap">
								<xsl:value-of select="itemCodeDetailMap" />
							</xsl:variable>

							<!-- added by cpatil on 12/05/14 start -->

							<xsl:variable name="supp_sour">
								<xsl:value-of select="supp_sour" />
							</xsl:variable>
							<xsl:variable name="source_supply">
								<xsl:value-of select="source_supply" />
							</xsl:variable>
							<xsl:variable name="unit">
								<xsl:value-of select="unit" />
							</xsl:variable>
							<xsl:variable name="originalOrAltitem">
								<xsl:value-of select="originalOrAltitem" />
							</xsl:variable>
							<xsl:variable name="order_type">
								<xsl:value-of select="order_type" />
							</xsl:variable>

							<xsl:variable name="itemType">
								<xsl:value-of select="itemType" />
							</xsl:variable>
							<xsl:variable name="sodemand">
								<xsl:value-of select="sodemand" />
							</xsl:variable>

							<xsl:variable name="demand">
								<xsl:value-of select="demand" />
							</xsl:variable>
							<xsl:variable name="other">
								<xsl:value-of select="other" />
							</xsl:variable>
							<xsl:variable name="gross_weight">
								<xsl:value-of select="gross_weight" />
							</xsl:variable>
							<xsl:variable name="supply">
								<xsl:value-of select="supply" />
							</xsl:variable>
							<xsl:variable name="net_req">
							</xsl:variable>

							<xsl:variable name="due_date">
								<xsl:value-of select="due_date" />
							</xsl:variable>
							
							<xsl:variable name="mfg_type">
								<xsl:value-of select="mfg_type" />
							</xsl:variable>
							
							<xsl:variable name="refDetails">
								<xsl:value-of select="refDetails" />
							</xsl:variable>
							<xsl:variable name="current_sorder">
								<xsl:value-of select="current_sorder" />
							</xsl:variable>
							
							<xsl:variable name="loc_group">
								<xsl:value-of select="loc_group" />
							</xsl:variable>
							
						
														
							<!-- [ :<xsl:value-of select="itemType"  	/>] -->
							<xsl:if test="$item_code != '' ">
							   <xsl:if test="$sodemand != '0.000' ">
								
							<!-- 	<xsl:if test="$originalOrAltitem != 'A' ">   -->

									<tr>
										<td class="td_leftAlign" align="left">
											<xsl:choose>
												<xsl:when test="$chkbox ='Y'">
													<script>
													<![CDATA[ orderVisit = parseInt("]]>
														<xsl:value-of select="order_of_visit" /><![CDATA[");]]>
													</script>
													<input type="checkbox"
														name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox"
														checked='Y' value="true"
														onClick="javaScript:setCheckedPlace(this, '{normalize-space($dbID)}' )" />
												</xsl:when>
												<xsl:otherwise>
													<input type="checkbox"
														name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox"
														value="false"
														onClick="javaScript:setCheckedPlace(this, '{normalize-space($dbID)}' )" />
												</xsl:otherwise>
											</xsl:choose>
										</td>

										<td class="td_leftAlign" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.itemDetailsInfo" id="Detail2.{normalize-space($dbID)}.itemDetailsInfo"
												value="{$itemDetailsInfo}" size="10" ISCHANGED="false" />
										 	<xsl:value-of select="itemDetailsInfo" />  
										</td>
										
										<td class="td_leftAlign" align="left">
																				
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.mfg_type" id="Detail2.{normalize-space($dbID)}.mfg_type"
												value="{$mfg_type}" size="10" ISCHANGED="false" />
											<!--  <xsl:value-of select="mfg_type" />   -->	
												<xsl:choose>
													<xsl:when test="mfg_type ='O'">
														<font size="2pt" face="Verdana"> Made To Order </font>
													</xsl:when>
													<xsl:when test="mfg_type ='S'">
														<font size="2pt" face="Verdana"> Made To Stock </font>
													</xsl:when>
													<xsl:when test="mfg_type ='D'">
														<font size="2pt" face="Verdana"> Designed To Order </font>
													</xsl:when>
													<xsl:when test="mfg_type ='F'">
														<font size="2pt" face="Verdana"> Bulk Manufacturing </font>
													</xsl:when>
													<xsl:when test="mfg_type ='P'">
														<font size="2pt" face="Verdana"> Packing </font>
													</xsl:when>
													<xsl:when test="mfg_type ='I'">
														<font size="2pt" face="Verdana"> Other Manufacturing </font>
													</xsl:when>
													<xsl:otherwise>
														<font size="2pt" face="Verdana">  </font>
													</xsl:otherwise>
												</xsl:choose>
										</td>
										
										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.supp_sour" id="Detail2.{normalize-space($dbID)}.supp_sour"
												value="{$supp_sour}" size="10" ISCHANGED="false" />
												<xsl:value-of select="supp_sour" />
										</td>
										<td class="td_leftAlign" align="left">
												<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.sale_order" id="Detail2.{normalize-space($dbID)}.sale_order"
												value="{$sale_order}" size="10" ISCHANGED="false" />
											<xsl:choose>
													<xsl:when test="line_no != null ">
														<font size="2pt" face="Verdana"></font>
													</xsl:when>
													<xsl:when test="line_no = '   ' ">
														<font size="2pt" face="Verdana"></font>
													</xsl:when>
													<xsl:when test="line_no = '  ' ">
														<font size="2pt" face="Verdana"></font>
													</xsl:when>
													<xsl:when test="line_no = ' ' ">
														<font size="2pt" face="Verdana"></font>
													</xsl:when>
													<xsl:when test="line_no = '' ">
														<font size="2pt" face="Verdana"></font>
													</xsl:when>
													<xsl:otherwise>
														<font size="2pt" face="Verdana"><xsl:value-of select="sale_order" /></font>
													</xsl:otherwise>
											</xsl:choose>
										</td>

										<td class="td_leftAlign" align="left">
											<input type="hidden" name="Detail2.{normalize-space($dbID)}.line_no"
												id="Detail2.{normalize-space($dbID)}.line_no" value="{$line_no}"
												size="04" ISCHANGED="false" />
											<xsl:value-of select="line_no" />
										</td>
										<td class="td_leftAlign" style="text-align:right">
											<input type="hidden" name="Detail2.{normalize-space($dbID)}.demand"
												id="Detail2.{normalize-space($dbID)}.demand" value="{$sodemand}"
												size="10" ISCHANGED="false" />
											<xsl:value-of select="sodemand" />
										</td>
										
										

										<td class="td_leftAlign" style="text-align:right">
										<a onMouseover="javascript:ddrivetip( 'refDetails','current_sorder');"
												onMouseout="javascript:hideddrivetip();"
												href="javascript:displaysOthersInfo('{normalize-space($refDetails)}','{normalize-space($current_sorder)}');">
										<!--  <xsl:choose>
											 	<xsl:when test=" number(gross_weight) = 0   ">
													<input type="hidden"
														name="Detail2.{normalize-space($dbID)}.net_req" id="Detail2.{normalize-space($dbID)}.net_req"
														value="{$net_req}" size="10" ISCHANGED="false" />
														0.0
												</xsl:when>
												<xsl:otherwise>
											 -->
											 		<input type="hidden" name="Detail2.{normalize-space($dbID)}.other"
												id="Detail2.{normalize-space($dbID)}.other" value="{$other}"
												size="10" ISCHANGED="false" />
												<xsl:value-of select="format-number(number(gross_weight) - number(sodemand), '######.000')" />
											<!--  	</xsl:otherwise>  
											</xsl:choose>   -->
										</a>	
										</td>
										
										
										<td class="td_leftAlign" style="text-align:right">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.gross_weight" id="Detail2.{normalize-space($dbID)}.gross_weight"
												value="{$gross_weight}" size="10" ISCHANGED="false" />
											<xsl:value-of select="gross_weight" />
										</td>
										
										<td class="td_leftAlign" style="text-align:right">
											<input type="td_rightAlign" style="text-align:right" name="Detail2.{normalize-space($dbID)}.supply"
												id="Detail2.{normalize-space($dbID)}.supply" value="{$supply}"
												size="10" ISCHANGED="false" readonly="readonly"/>
										<!-- 	<xsl:value-of select="supply" />  -->
										</td>
										<!-- <td class="td_leftAlign" align="left"> <input type="hidden" 
											name="Detail2.{normalize-space($dbID)}.net_req" id="Detail2.{normalize-space($dbID)}.net_req" 
											value="{$net_req}" size="10" ISCHANGED="false" /> <xsl:value-of select="number(gross_weight) 
											- number(supply)"/> </td> -->

										<td class="td_leftAlign" style="text-align:right">
											<xsl:choose>
												<xsl:when test=" number(supply) > number(demand)   ">
													0
												</xsl:when>
												<xsl:when test=" number(gross_weight) = 0   ">
													<input type="hidden"
														name="Detail2.{normalize-space($dbID)}.net_req" id="Detail2.{normalize-space($dbID)}.net_req"
														value="{$net_req}" size="10" ISCHANGED="false" />
														<xsl:value-of select="format-number(number(demand) - number(supply), '######.000')" />
												<!--	<xsl:value-of select="number(demand)-number(supply)" />    -->
												</xsl:when>
												<xsl:otherwise>
													<input type="hidden"
														name="Detail2.{normalize-space($dbID)}.net_req" id="Detail2.{normalize-space($dbID)}.net_req"
														value="{$net_req}" size="10" ISCHANGED="false" />
													<xsl:value-of select="format-number(number(gross_weight) - number(supply), '######.000')" />
												<!-- 	<xsl:value-of select="number(gross_weight) - number(supply)" />   -->
												</xsl:otherwise>
											</xsl:choose>
										</td>


										

										<td class="td_leftAlign" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.site_code" id="Detail2.{normalize-space($dbID)}.site_code"
												value="{$site_code}" size="10" ISCHANGED="false" />
											<xsl:value-of select="site_code" />
										</td>

										<!-- added by cpatil on 12/05/14 start -->

										<!-- <td class="hide" align="left"> <input type="hidden" name="Detail2.{normalize-space($dbID)}.bom_code_parent" 
											id="Detail2.{normalize-space($dbID)}.bom_code_parent" value="{$bom_code_parent}" 
											size="10" ISCHANGED="false" /> </td> -->
										<td class="td_leftAlign" align="left">

											<xsl:choose>
												<xsl:when test="supp_sour ='P'">

													<input type="test"
														name="Detail2.{normalize-space($dbID)}.bom_code_ref" id="Detail2.{normalize-space($dbID)}.bom_code_ref"
														value="{$bom_code_ref}" size="10" ISCHANGED="false"
														readonly="readonly" />

												</xsl:when>
												<xsl:otherwise>

													<input type="text"
														name="Detail2.{normalize-space($dbID)}.bom_code_ref" id="Detail2.{normalize-space($dbID)}.bom_code_ref"
														value="{$bom_code_ref}" size="10" ISCHANGED="false" />

													<a
														href="javascript:callPopHelpJSP( '{normalize-space($dbID)}','{normalize-space($item_code)}','{normalize-space($site_code)}' );">
														<img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg"
															border="0" />
													</a>

													<!-- <xsl:value-of select="supply" /> -->
												</xsl:otherwise>
											</xsl:choose>

										</td>

										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.bom_code_org" id="Detail2.{normalize-space($dbID)}.bom_code_org"
												value="{$bom_code_org}" size="10" ISCHANGED="false" />
										</td>
										
										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.source_supply_ref"
												id="Detail2.{normalize-space($dbID)}.source_supply_ref"
												value="{$source_supply}" size="10" ISCHANGED="false" />
										</td>
										
										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.itemCodeDetailMap"
												id="Detail2.{normalize-space($dbID)}.itemCodeDetailMap"
												value="{$itemCodeDetailMap}" size="10" ISCHANGED="false" />
										</td>
										
										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.order_type" id="Detail2.{normalize-space($dbID)}.order_type"
												value="{$order_type}" size="10" ISCHANGED="false" />
										</td>

										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.current_sorder" id="Detail2.{normalize-space($dbID)}.current_sorder"
												value="{$current_sorder}" size="10" ISCHANGED="false" />
										</td>

										<!-- added by cpatil on 12/05/14 start -->


										<td class="td_leftAlign" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.item_code" id="Detail2.{normalize-space($dbID)}.item_code"
												value="{$item_code}" size="10" ISCHANGED="false" />
											<xsl:value-of select="item_code" />
										</td>

										<td class="hide" align="left">

											<xsl:choose>
												<xsl:when test="bom_code_parent =''">
													<font size="2pt" face="Verdana">1</font>
												</xsl:when>
												<xsl:otherwise>
													<font size="2pt" face="Verdana">
														<input type="hidden"
															name="Detail2.{normalize-space($dbID)}.itemType" id="Detail2.{normalize-space($dbID)}.itemType"
															value="{$itemType}" size="10" ISCHANGED="false" />
														<xsl:value-of select="itemType" />
													</font>
												</xsl:otherwise>
											</xsl:choose>

										</td>

										<td class="td_leftAlign" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.item_code_descr" id="Detail2.{normalize-space($dbID)}.item_code_descr"
												value="{$item_code_descr}" size="10" ISCHANGED="false" />
											<xsl:value-of select="item_code_descr" />
										</td>
										
										<td class="td_leftAlign" style="text-align:right">
											<input type="hidden" name="Detail2.{normalize-space($dbID)}.qty_reqd"
												id="Detail2.{normalize-space($dbID)}.qty_reqd" value="{$demand}"
												size="04" ISCHANGED="false" />
											<xsl:value-of select="sodemand" />  
										</td>
										<td class="td_leftAlign" style="text-align:right">
											<input type="hidden" name="Detail2.{normalize-space($dbID)}.unit"
												id="Detail2.{normalize-space($dbID)}.unit" value="{$unit}"
												size="04" ISCHANGED="false" />
											<xsl:value-of select="unit" />
										</td>

										<td class="td_leftAlign" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.bom_code_parent" id="Detail2.{normalize-space($dbID)}.bom_code_parent"
												value="{$bom_code_parent}" size="10" ISCHANGED="false" />
											<xsl:value-of select="bom_code_parent" />
										</td>

										<td class="td_leftAlign" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.due_date" id="Detail2.{normalize-space($dbID)}.due_date"
												value="{$due_date}" size="10" ISCHANGED="false" />
											<xsl:value-of select="due_date" />
										</td>
										
										<td class="hide" align="left">
											<input type="hidden"
												name="Detail2.{normalize-space($dbID)}.loc_group"
												id="Detail2.{normalize-space($dbID)}.loc_group"
												value="{$loc_group}" size="10" ISCHANGED="false" />
										</td>
										
										<td class="td_leftAlign" align="left">
									 
											<a onMouseover="javascript:ddrivetip( 'source_supply','white');"
												onMouseout="javascript:hideddrivetip();"
												href="javascript:callSupplyItemJSP('{normalize-space($dbID)}','{normalize-space($sale_order)}','{normalize-space($line_no)}','{normalize-space($qty_reqd)}','{normalize-space($due_date)}');">
												<!-- 
												<xsl:choose>
													<xsl:when test="source_supply ='S'">
														<font size="2pt" face="Verdana"> Stock </font>
													</xsl:when>
													<xsl:when test="source_supply ='W'">
														<font size="2pt" face="Verdana"> WIP </font>
													</xsl:when>
													<xsl:when test="source_supply ='P'">
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='SW'">
														<font size="2pt" face="Verdana"> Stock- </font>
														<font size="2pt" face="Verdana"> WIP </font>
													</xsl:when>
													<xsl:when test="source_supply ='WS'">
														<font size="2pt" face="Verdana"> Stock- </font>
														<font size="2pt" face="Verdana"> WIP </font>
													</xsl:when>
													<xsl:when test="source_supply ='SP'">
														<font size="2pt" face="Verdana"> Stock- </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='PS'">
														<font size="2pt" face="Verdana"> Stock- </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='WP'">
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='PW'">
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='SWP'">
														<font size="2pt" face="Verdana"> Stock - </font>
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='SPW'">
														<font size="2pt" face="Verdana"> Stock - </font>
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='WSP'">
														<font size="2pt" face="Verdana"> Stock - </font>
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='WPS'">
														<font size="2pt" face="Verdana"> Stock - </font>
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='PSW'">
														<font size="2pt" face="Verdana"> Stock - </font>
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:when test="source_supply ='PWS'">
														<font size="2pt" face="Verdana"> Stock - </font>
														<font size="2pt" face="Verdana"> WIP - </font>
														<font size="2pt" face="Verdana"> Planned </font>
													</xsl:when>
													<xsl:otherwise>
														<font size="2pt" face="Verdana"> Supply </font>
													</xsl:otherwise>
												</xsl:choose>
												-->
												<font size="2pt" face="Verdana"> Supply </font>
											</a>
											
											<input type="button"  value="Allocate" title='Allocate' onclick="Allocate('{normalize-space($dbID)}','{normalize-space($loc_group)}','{normalize-space($due_date)}','{normalize-space($sale_order)}','{normalize-space($item_code)}');" />  
 										
											<xsl:for-each select="//Detail2/Detail4">

												<xsl:variable name="dbID">
													<xsl:value-of select="@domID" />
												</xsl:variable>
												<!-- xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable -->
								 

												<div id="sample_item{normalize-space($dbID)}" name="sample_item{normalize-space($dbID)}">
													<span id="sample_item{normalize-space($dbID)}">
														<font size="2pt" face="Verdana">

															<xsl:variable name="Detail4_site_code">
																<xsl:value-of select="site_code" />
															</xsl:variable>
															<xsl:variable name="Detail4_item_code">
																<xsl:value-of select="item_code" />
															</xsl:variable>
															<xsl:variable name="Detail4_item_code_descr">
																<xsl:value-of select="item_code_descr" />
															</xsl:variable>
															<xsl:variable name="Detail4_lot_no">
																<xsl:value-of select="lot_no" />
															</xsl:variable>
															<xsl:variable name="Detail4_lot_sl">
																<xsl:value-of select="lot_sl" />
															</xsl:variable>
															<xsl:variable name="Detail4_loc_code">
																<xsl:value-of select="loc_code" />
															</xsl:variable>
															<xsl:variable name="Detail4_tran_ser">
																<xsl:value-of select="tran_ser" />
															</xsl:variable>
															<xsl:variable name="Detail4_tran_id">
																<xsl:value-of select="tran_id" />
															</xsl:variable>
															<xsl:variable name="Detail4_ref_line_no">
																<xsl:value-of select="line_no" />
															</xsl:variable>
															<xsl:variable name="Detail4_supply">
																<xsl:value-of select="supply" />
															</xsl:variable>
															<xsl:variable name="Detail4_alloc_qty">
																<xsl:value-of select="alloc_qty" />
															</xsl:variable>
															<xsl:variable name="Detail4_unit">
																<xsl:value-of select="unit" />
															</xsl:variable>
															<xsl:variable name="Detail4_planned_quantity">
																<xsl:value-of select="planned_quantity" />
															</xsl:variable>

															<xsl:variable name="Detail4_parent_item">
																<xsl:value-of select="parent_item" />
															</xsl:variable>

															<xsl:variable name="Detail4_source_supply">
																<xsl:value-of select="source_supply" />
															</xsl:variable>

															<!-- for new -->
															<xsl:variable name="Detail4_item_code_parent">
																<xsl:value-of select="item_code_parent" />
															</xsl:variable>

															<xsl:variable name="Detail4_prev_item_worder">
																<xsl:value-of select="prev_item_worder" />
															</xsl:variable>
															<xsl:variable name="Detail4_previous_item">
																<xsl:value-of select="previous_item" />
															</xsl:variable>

															<xsl:variable name="Detail4_originalOrAltitem">
																<xsl:value-of select="originalOrAltitem" />
															</xsl:variable>

															<xsl:variable name="Detail4_new_planned_supply">
																<xsl:value-of select="new_planned_supply" />
															</xsl:variable>
															
															<xsl:variable name="Detail4_due_date1">
																<xsl:value-of select="due_date1" />       
															</xsl:variable>

															<xsl:variable name="Detail4_alloc_pref">
																<xsl:value-of select="alloc_pref" />       
															</xsl:variable>
															
															<xsl:variable name="Detail4_alt_item_perc">
																<xsl:value-of select="alt_item_perc" />       
															</xsl:variable>

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.site_code"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.site_code"
																value="{$Detail4_site_code}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_site_code" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.item_code"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.item_code"
																value="{$Detail4_item_code}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_item_code" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.item_code_descr"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.item_code_descr"
																value="{$Detail4_item_code_descr}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_item_code_descr" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.lot_no"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.lot_no"
																value="{$Detail4_lot_no}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_lot_no" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.lot_sl"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.lot_sl"
																value="{$Detail4_lot_sl}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_lot_sl" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.loc_code"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.loc_code"
																value="{$Detail4_loc_code}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_loc_code" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.tran_ser"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.tran_ser"
																value="{$Detail4_tran_ser}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_tran_ser" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.tran_id"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.tran_id"
																value="{$Detail4_tran_id}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_tran_id" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.ref_line_no"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.ref_line_no"
																value="{$Detail4_ref_line_no}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_ref_line_no" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.supply"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.supply"
																value="{$Detail4_supply}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_supply" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.alloc_qty"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.alloc_qty"
																value="{$Detail4_alloc_qty}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_alloc_qty" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.unit"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.unit"
																value="{$Detail4_unit}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_unit" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.planned_quantity"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.planned_quantity"
																value="{$Detail4_planned_quantity}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_planned_quantity" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.parent_item"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.parent_item"
																value="{$Detail4_parent_item}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_parent_item" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.source_supply"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.source_supply"
																value="{$Detail4_source_supply}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_source_supply" />


															<!-- for test -->
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.item_code_parent"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.item_code_parent"
																value="{$Detail4_item_code_parent}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_item_code_parent" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.prev_item_worder"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.prev_item_worder"
																value="{$Detail4_prev_item_worder}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_prev_item_worder" />
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.previous_item"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.previous_item"
																value="{$Detail4_previous_item}" size="10" ISCHANGED="false" />
															<xsl:value-of select="Detail4_previous_item" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.originalOrAltitem"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.originalOrAltitem"
																value="{$Detail4_originalOrAltitem}" size="10"
																ISCHANGED="false" />
															<xsl:value-of select="Detail4_originalOrAltitem" />

															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.new_planned_supply"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.new_planned_supply"
																value="{$Detail4_new_planned_supply}" size="10"
																ISCHANGED="false" />
															<xsl:value-of select="Detail4_new_planned_supply" />
															
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.due_date1"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.due_date1"
																value="{$Detail4_due_date1}" size="10"
																ISCHANGED="false" />
															<xsl:value-of select="Detail4_due_date1" />
															
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.alloc_pref"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.alloc_pref"
																value="{$Detail4_alloc_pref}" size="10"
																ISCHANGED="false" />
															<xsl:value-of select="Detail4_alloc_pref" />
															
															<input type="hidden"
																name="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.alt_item_perc"
																id="Detail4.{normalize-space($sale_order)}.{normalize-space($line_no)}.{normalize-space($dbID)}.{normalize-space($due_date)}.alt_item_perc"
																value="{$Detail4_alt_item_perc}" size="10"
																ISCHANGED="false" />
															<xsl:value-of select="Detail4_alt_item_perc" />
															
															
															

														</font>
													</span>
												</div>
												

											</xsl:for-each>

										</td>
										<!-- <td class="hide" style="text-align:right" > <input type="hidden" 
											name="Detail2.{normalize-space($dbID)}.source_supply" id="Detail2.{normalize-space($dbID)}.source_supply" 
											value="{$source_supply}" size="00" ISCHANGED="false" /> <xsl:value-of select="source_supply" 
											/> </td> -->


									</tr>
								<!-- 	</xsl:if>   -->
								</xsl:if>
							</xsl:if>
						</xsl:for-each>

						<!-- <div id = "stockItem" name="stockItem"> <span id = "stockItem" 
							><font size="2pt" face="Verdana"> <xsl:for-each select="//Detail2/Detail4"> 
							<xsl:variable name="dbID1"><xsl:value-of select="@domID"/></xsl:variable> 
							<xsl:variable name="stkDetail4_site_code"><xsl:value-of select="site_code"/></xsl:variable> 
							<xsl:variable name="stkDetail4_item_code"><xsl:value-of select="item_code"/></xsl:variable> 
							<xsl:variable name="stkDetail4_lot_no"><xsl:value-of select="lot_no"/></xsl:variable> 
							<xsl:variable name="stkDetail4_lot_sl"><xsl:value-of select="lot_sl"/></xsl:variable> 
							<xsl:variable name="stkDetail4_loc_code"><xsl:value-of select="loc_code"/></xsl:variable> 
							<xsl:variable name="stkDetail4_tran_ser"><xsl:value-of select="tran_ser"/></xsl:variable> 
							<xsl:variable name="stkDetail4_tran_id"><xsl:value-of select="tran_id"/></xsl:variable> 
							<xsl:variable name="stkDetail4_line_no"><xsl:value-of select="line_no"/></xsl:variable> 
							<xsl:variable name="stkDetail4_supply"><xsl:value-of select="supply"/></xsl:variable> 
							<xsl:variable name="stkDetail4_alloc_qty"><xsl:value-of select="alloc_qty"/></xsl:variable> 
							<xsl:value-of select="dbID"/><xsl:text> :div id:</xsl:text><xsl:value-of 
							select="dbID1"/> <input type="text" name="stkDetail4.{normalize-space($dbID1)}.site_code" 
							id="stkDetail4.{normalize-space($dbID1)}.site_code" value="{$stkDetail4_site_code}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_site_code"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.item_code" 
							id="stkDetail4.{normalize-space($dbID1)}.item_code" value="{$stkDetail4_item_code}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_item_code"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.lot_no" id="stkDetail4.{normalize-space($dbID1)}.lot_no" 
							value="{$stkDetail4_lot_no}" size="10" ISCHANGED="false"/> <xsl:value-of 
							select="stkDetail4_lot_no"/> <input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.lot_sl" 
							id="stkDetail4.{normalize-space($dbID1)}.lot_sl" value="{$stkDetail4_lot_sl}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_lot_sl"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.loc_code" 
							id="stkDetail4.{normalize-space($dbID1)}.loc_code" value="{$stkDetail4_loc_code}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_loc_code"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.tran_ser" 
							id="stkDetail4.{normalize-space($dbID1)}.tran_ser" value="{$stkDetail4_tran_ser}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_tran_ser"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.tran_id" 
							id="stkDetail4.{normalize-space($dbID1)}.tran_id" value="{$stkDetail4_tran_id}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_tran_id"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.line_no" 
							id="stkDetail4.{normalize-space($dbID1)}.line_no" value="{$stkDetail4_line_no}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_line_no"/> 
							<input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.supply" id="stkDetail4.{normalize-space($dbID1)}.supply" 
							value="{$stkDetail4_supply}" size="10" ISCHANGED="false"/> <xsl:value-of 
							select="stkDetail4_supply"/> <input type="hidden" name="stkDetail4.{normalize-space($dbID1)}.alloc_qty" 
							id="stkDetail4.{normalize-space($dbID1)}.alloc_qty" value="{$stkDetail4_alloc_qty}" 
							size="10" ISCHANGED="false"/> <xsl:value-of select="stkDetail4_alloc_qty"/> 
							</xsl:for-each> </font></span> </div> -->




					</table>
					<div id="repeatPlacesDiv" style="margin-left:10px"></div>
					<table>
						<tr>
							<td>
								<input type="hidden" value="3" name="FORM_NO" ID="FORM_NO" />
								<input type="hidden" value="mrp_run_wiz" name="OBJ_NAME" />
								<input type="hidden" value="" name="action" id="action" />

								<input type="submit" style="cursor:hand" value="Cancel"
									id="Cancel" name="Cancel" title=''
									onclick="javascript:setActionVal('previous')" />

								<!--input type="submit" style="cursor:hand" value="Next" id="Next" 
									name="Next" title='' onclick="javascript:setActionVal('next')"/ <input type="submit" 
									style="cursor:hand" value="Finish" id="Finish" name="Finish" title='' onclick="javascript:setActionVal('finish')" 
									/> -->

								<input type="submit" style="cursor:hand" value="Finish"
									id="Finish" name="Finish" title='' onclick="return finishAction('finish')" />
								<!-- <input type="button" style="cursor:hand" value="Export" id="export" 
									name="export" title='' onclick="javascript:callRumMrpExportJSP('export')" 
									/> -->
								<!-- <input type="button" style="cursor:hand" value="Recalculate" 
									id="recalculate" name="recalculate" title='' onclick="javascript:recalculate()"/> -->
								<input type="button" value="Recalculate" title='Recalculate'  id="Recalculate"
									onclick="recalculate();" />

								<!-- <input type="submit" style="cursor:hand" value="Recalculate" 
									id="Next" name="Next" title='' onclick="javascript:setActionVal('next')"/> -->

							</td>
						</tr>
					</table>
					<table id="errorTravelTable" width="85%" class="tableClass"
						border="0" cellspacing="1" cellpadding="1">
						<xsl:for-each select="//error">
							<xsl:variable name="message">
								<xsl:value-of select="message" />
							</xsl:variable>
							<xsl:variable name="description">
								<xsl:value-of select="description" />
							</xsl:variable>
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:variable name="dbID">
								<xsl:value-of select="@domId" />
							</xsl:variable>
							<xsl:variable name="column_name">
								<xsl:value-of select="@column_name" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<tr>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Message :
									</td>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Description :
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="message" />
								</td>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="description" />
								</td>
							</tr>
						</xsl:for-each>
						<xsl:for-each select="//error">
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<xsl:if test="$type = 'W'">
									<tr>
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											Override
											Warnings :
										</td>
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											<input type="checkbox" name="forceSave" value="false"
												onClick="javascript:setChecked(this)" />
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:for-each>
					</table>

				</form>
			</body>

		</html>
	</xsl:template>
</xsl:stylesheet>
