package ibase.webitm.ejb.dis;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.Stateless;

import org.apache.commons.collections.map.HashedMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
/**
 * Session Bean implementation class EnterpriseIC
 */
@Stateless
public class EnterpriseIC extends ValidatorEJB implements EnterpriseICRemote, EnterpriseICLocal 
{	
	E12GenericUtility genericUtility = new E12GenericUtility();
	
   	
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException  
    {
   		Document dom = null; 
   		Document dom1 = null; 
   		Document dom2 = null;
   		String retString = "";	
   		try
   		{
   			System.out.println("*************** Inside wfValData *******************");  	
    	    System.out.println("Value in xmlString ::::"+xmlString);
    	    System.out.println("Value in xmlString1 ::::"+xmlString1);
    	    System.out.println("Value in xmlString2 ::::"+xmlString2);
    	    
	   		if(xmlString != null && xmlString.trim().length()>0)
	   		{
	   			dom = genericUtility.parseString(xmlString);		
	   		}
	   		if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
	   			dom1 = genericUtility.parseString(xmlString1);
	   		}
	   		if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
	   			dom2 = genericUtility.parseString(xmlString2);
	   		}
	   		retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
	   		System.out.println("errorString::::::::::"+retString);
		}
        catch(Exception e)
        {
	        System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
        }
        return retString;	    
	}//end of method wfValData
   	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String errorType = "",errString="";
		String errCode = "",userId = "",updateFlag="";
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		int childNodeLength = 0 , ctr = 0,cnt = 0;
		HashMap<Integer,String> resourceVal = null;
		String childNodeName = "",enterpriseId = "",resourceId = "",resIdVal="";
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			conn = getConnection();
			resourceVal = new HashMap<Integer,String>();
			if(objContext != null && objContext.trim().length()>0)
			{
			    currentFormNo = Integer.parseInt(objContext);
			    System.out.println("currentFormNo::: in Validation"+currentFormNo);
			    switch(currentFormNo)
			    {
			    	case 1:
			    	{
			    		parentNodeList = dom.getElementsByTagName("Detail1");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{		    				
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName for Detail1:::"+childNodeName);
		    				
		    				if("enterprise".equalsIgnoreCase(childNodeName))
		    				{
		    					enterpriseId = checkNullAndTrim(genericUtility.getColumnValue("enterprise",dom)).trim();
		    					System.out.println("Enterprise Id ["+enterpriseId+"]");
		    					if(enterpriseId == null || enterpriseId.trim().length() == 0)
		    					{
		    						errCode = "VTBLKEPSID";
				    				errList.add(errCode);
				    				errFields.add(childNodeName.toLowerCase());
		    					}
		    					else if(enterpriseId != null || enterpriseId.trim().length() > 0)
		    					{
		    						 sql = "select count(*) as cnt from enterprise where enterprise=?";
		    						 pstmt = conn.prepareStatement(sql);
				    				 pstmt.setString(1,enterpriseId);
				    				 rs = pstmt.executeQuery();
				    				 if(rs.next())
				    				 {
				    					 cnt = rs.getInt("cnt");
				    				 }
				    				 if(pstmt != null)
				    				 {
				    					 pstmt.close(); 
				    					 pstmt = null;
				    				 }
				    				 if(rs != null)
				    				 {
				    					 rs.close();
				    					 rs = null;
				    				 }	
				    				 if(cnt > 0)
				    				 {
				    					    errCode = "VTINVEPSID";
						    				errList.add(errCode);
						    				errFields.add(childNodeName.toLowerCase());
				    				 }
		    					}
		    				}
		    				
		    			}
			    	}//end of case1
			    	break;
			    	case 2:
			    	{
			    		parentNodeList = dom.getElementsByTagName("Detail2");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName for Detail2:::"+childNodeName);
		    				
		    				if("res_id".equalsIgnoreCase(childNodeName))
		    				{
		    					resourceId = checkNullAndTrim(genericUtility.getColumnValue("res_id",dom)).trim();
		    					System.out.println("Resource Id ["+resourceId+"]");
		    					if(resourceId == null || resourceId.trim().length() == 0)
		    					{
		    						errCode = "VMNURESID";
				    				errList.add(errCode);
				    				errFields.add(childNodeName.toLowerCase());
		    					}
		    					else if(resourceId != null && resourceId.trim().length() > 0)
		    					{						
		    						System.out.println("detailString value is =="+genericUtility.serializeDom(dom2));
		    						int detlCnt = getNumOfNonDelDetail(dom2,2);
									System.out.println("DETAIL COUNT" +detlCnt);
									if(detlCnt > 1)
									{
										NodeList detailNoteList = dom2.getElementsByTagName("Detail2");
										System.out.println("detailNoteList Length ::: ["+detailNoteList.getLength()+"]");
										for(int cntr = 0;cntr<detailNoteList.getLength();cntr++)
										{
											Node pNode=detailNoteList.item(cntr);
											childNodeName = pNode.getNodeName();
											updateFlag = getAttributeVal(pNode,"updateFlag");
											System.out.println("childNodeName ::["+childNodeName+"]" + "updateFlag :: ["+updateFlag+"]");
											resIdVal = checkNullAndTrim(genericUtility.getColumnValueFromNode("res_id", pNode));				
											System.out.println("Resource ID Value is XML:::"+resIdVal);
											System.out.println("Current Resource ID Value is :::"+resourceId);
											if(!(resourceVal.isEmpty()) && resourceVal.containsValue(resourceId) && !("D".equalsIgnoreCase(updateFlag)))
											{
												errCode = "VTINVRESID";
							    				errList.add(errCode);
							    				errFields.add(childNodeName.toLowerCase());
											}
											resourceVal.put(cntr, resIdVal);											
										}
										System.out.println("Values in HashMap Current:::::::::["+resourceVal+"]");									
									}
									
		    					}		
		    				}
		    			}
			    	}//end of case2
			    	break;
			    }//end of switch statement
			    int errListSize = errList.size();
			    System.out.println("errListSize::::::::::"+errListSize);
			    int count = 0;
			    String errFldName = null;
			    if (errList != null && errListSize > 0)
			    {
			    	for (count = 0; count < errListSize; count++)
			    	{
			    		errCode = errList.get(count);
			    		errFldName = errFields.get(count);
			    		System.out.println(" testing :errCode .:" + errCode);
			    		errString = getErrorString(errFldName, errCode, userId);
			    		System.out.println("errString>>>>>>>>>"+errString);
			    		errorType = errorType(conn, errCode);
			    		if (errString.length() > 0)
			    		{
			    			String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
			    			bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
			    			errStringXml.append(bifurErrString);
			    			errString = "";
			    		}
			    		if (errorType.equalsIgnoreCase("E"))
			    		{
			    			break;
			    		}
			    	}//end of for loop
			    	errList.clear();
			    	errList = null;
			    	errFields.clear();
			    	errFields = null;
			    	errStringXml.append("</Errors> </Root> \r\n");
			    } 
			    else
			    {
			    	errStringXml = new StringBuffer("");
			    }
			}
			
		}//end of try block
		catch(Exception e)
		{
			System.out.println(e);
			e.printStackTrace();
			throw new ITMException(e);
		}//end of catch block
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
						conn.close();
					}
					conn = null;
				} 
				catch (Exception d)
				{
					d.printStackTrace();
					throw new ITMException(d);
				}
		}//end of finally block
		errString = errStringXml.toString();
		System.out.println("testing : final errString : " + errString);
		return errString;
	}// end of wfvalData method
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}//end of method checkNullAndTrim
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException 
	{
		Document dom=null;
		Document domhr=null;
		Document domAll=null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			System.out.println("Value in xmlString ::::"+xmlString);
    	    System.out.println("Value in xmlString1 ::::"+xmlString1);
    	    System.out.println("Value in xmlString2 ::::"+xmlString2);
			if(xmlString != null && xmlString.trim().length()>0)
	   		{
				dom = genericUtility.parseString(xmlString);		
	   		}
			if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
				domhr = genericUtility.parseString(xmlString1);		
	   		}
			if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
				domAll = genericUtility.parseString(xmlString2);		
	   		}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);
			System.out.println("retString123::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 	
			throw new ITMException(e);
		}
		return retString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo=0,ctr = 0;	
		String loginSite = "";
		NodeList parentNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		String childNodeName = "",enterpriseDescr = "",resId = "",sql="",resDescr="";
		int childNodeListLength = 0;
		StringBuffer valueXmlString = new StringBuffer();		
		try
		{
			conn = getConnection();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			System.out.println("loginSiteCode is>>>>>>>>>>>"+loginSite);
			System.out.println("[EnterpriseIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail1>\r\n");
					childNodeListLength = childNodeList.getLength();
					System.out.println("currentColumn-----for case1--->>[" + currentColumn + "]");
				}
				valueXmlString.append("</Detail1>\r\n");
				break;
				
				case 2:
				{
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail2>\r\n");
					childNodeListLength = childNodeList.getLength();
					System.out.println("currentColumn-----for case2--->>[" + currentColumn + "]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						enterpriseDescr = checkNullAndTrim(genericUtility.getColumnValue("enterprise_descr", dom1));
						System.out.println("Enterprise Description is ["+enterpriseDescr+"]");
			
						valueXmlString.append("<enterprise_descr><![CDATA[" ).append(enterpriseDescr).append( "]]></enterprise_descr>\r\n" );						
					}
					else if("res_id".equalsIgnoreCase(currentColumn.trim()))
					{
						resId = checkNullAndTrim(genericUtility.getColumnValue("res_id", dom));
						System.out.println("Resource ID is ["+resId+"]");
						
						if(resId != null && resId.trim().length() > 0)
						{
							 sql = "select descr from resources where res_id=?";
							 pstmt = conn.prepareStatement(sql);
		    				 pstmt.setString(1,resId);
		    				 rs = pstmt.executeQuery();
		    				 if(rs.next())
		    				 {
		    					 resDescr = rs.getString("descr");
		    				 }
		    				 if(pstmt != null)
		    				 {
		    					 pstmt.close(); 
		    					 pstmt = null;
		    				 }
		    				 if(rs != null)
		    				 {
		    					 rs.close();
		    					 rs = null;
		    				 }	
		    				 
		    				 valueXmlString.append("<resources_descr><![CDATA[" ).append(resDescr).append( "]]></resources_descr>\r\n" );
						}
					}
				}
				valueXmlString.append("</Detail2>\r\n");
				break;
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return valueXmlString.toString();
	}

	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		} 
		catch (Exception ex)
		{
			System.out.println("Exception inside errorType method"+ex);
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}//end of method errorType	
	
	public int getNumOfNonDelDetail(Document dom2,int detailNo)
	{
		Node childNode = null;
		NodeList updateList;
		String childNodeName = "";
		String updateFlag="";
		int cntr=0;
		System.out.println("Inside getXmlDocument method!!!!!!!!!!!!!!");
		try
		{
			System.out.println("detailString value is =="+genericUtility.serializeDom(dom2));
			NodeList detailNoteList = dom2.getElementsByTagName("Detail"+detailNo);
			for(int cnt = 0;cnt<detailNoteList.getLength();cnt++)
			{
				Node pNode=detailNoteList.item(cnt);
				/*NodeList cNodeList=pNode.getChildNodes();
				childNodeListLength = cNodeList.getLength();*/			
				childNodeName = pNode.getNodeName();
				//System.out.println("pNode::["+pNode+"]"+"cNodeList::["+cNodeList+"]");
				updateFlag = getAttributeVal(pNode,"updateFlag");
				System.out.println("updateFlag [" + updateFlag + "]");
				if(!updateFlag.equalsIgnoreCase("D"))
				{
					cntr++;
				}
				System.out.println("Counter is ==="+cntr);	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : : getNumOfNonDelDetail :"+e); 
			e.printStackTrace();
		}
		return cntr;
	}
	
	public String getAttributeVal(Node dom, String attribName )throws ITMException
	{
		String AttribValue = null;
		try
		{
			NodeList detailList = dom.getChildNodes(); 
			int detListLength = detailList.getLength();
			for(int ctr = 0; ctr < detListLength; ctr++)
			{
				Node curDetail = detailList.item(ctr);
				if(curDetail.getNodeName().equals("attribute")) 
				{
					AttribValue = curDetail.getAttributes().getNamedItem(attribName).getNodeValue();
					break;
				}
				else
				{
					continue;
				}
			}		
		}
		catch (Exception e)
		{
			System.out.println("Exception : : searchNode :"+e); 
			throw new ITMException(e);
		}
		return AttribValue;
	}
}//end of class EnterpriseIC














