package ibase.e12ria.e12widgets.gwtmedia.client.event;

import java.util.List;

import com.google.gwt.user.client.Event;

public class PlayEvent extends Event {
	
	public static final int ONPLAY = 0;
	public static final int ONPAUSE = 1;
	public static final int ONSTOP = 2;
	
	protected final int state;
	
	protected PlayEvent(int state) {
		this.state = state;
	}
	
	public static void fire(List<PlayStateHandler> handlers, int state) {
		if (handlers == null) {
			return;
		}
		for (PlayStateHandler handler : handlers) {
			if (handler != null) {
				switch (state) {
				case PlayEvent.ONPLAY:
					handler.onPlay(new PlayEvent(state));
					break;
				case PlayEvent.ONPAUSE:
					handler.onPause(new PlayEvent(state));
					break;
				case PlayEvent.ONSTOP:
					handler.onStop(new PlayEvent(state));
					break;
				}
			}
		}
	}
	
}
