/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ArgumentBean;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.ITMFilterRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMFilterModel {
    static String FILTER_NAMES_SEP = ":";
    static String FILTER_TYPES_SEP = ":";
    static String FILTER_VALUES_SEP = ":";
    private UserInfoBean userInfo = null;
    private String objName = "";
    private ITMFilterRemote itmFilterComp = null;
    private String formalFilterInfoStr = "";
    private ArrayList formalFilterNamesList = null;
    private ArrayList formalFilterTypesList = null;
    private ArrayList formalFilterValuesList = null;
    private String formalFilterValuesStr = null;
    private ArrayList formalFilterDefaultValuesList = null;
    private ArrayList formalFilterDisplayNamesList = null;
    private ArrayList userFilterNamesList = null;
    private ArrayList userFilterExprList = null;
    private ArrayList userFilterValuesList = null;
    ArrayList defaultOptList = new ArrayList();
    private ArrayList applnFilterNamesList = null;
    private ArrayList applnFilterTypesList = null;
    private ArrayList applnFilterValuesList = null;
    public String dispDateFormat = "";

    public ITMFilterModel() throws ITMException {
        this("", null);
    }

    public ITMFilterModel(String string) throws ITMException {
        this(string, null);
    }

    public ITMFilterModel(String string, UserInfoBean userInfoBean) throws ITMException {
        try {
            this.objName = string;
            this.userInfo = userInfoBean;
            this.formalFilterNamesList = new ArrayList();
            this.formalFilterTypesList = new ArrayList();
            this.formalFilterValuesList = new ArrayList();
            this.formalFilterDefaultValuesList = new ArrayList();
            this.formalFilterDisplayNamesList = new ArrayList();
            this.userFilterNamesList = new ArrayList();
            this.userFilterExprList = new ArrayList();
            this.userFilterValuesList = new ArrayList();
            this.applnFilterNamesList = new ArrayList();
            this.applnFilterTypesList = new ArrayList();
            this.applnFilterValuesList = new ArrayList();
            this.setITMFilterComp();
            this.setFormalFilterInfoStr();
            this.setUserFilterInfoStr();
        }
        catch (ITMException iTMException) {
            iTMException.printStackTrace();
            throw iTMException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ITMException(exception);
        }
    }

    public String getObjName() {
        return this.objName;
    }

    public ArrayList getFormalFilterNamesList() {
        return this.formalFilterNamesList;
    }

    public String getFormalFilterNamesString() {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.formalFilterNamesList.size(); ++i) {
            stringBuffer.append((String)this.formalFilterNamesList.get(i)).append(FILTER_NAMES_SEP);
        }
        string = stringBuffer.toString();
        if (string.endsWith(FILTER_NAMES_SEP)) {
            string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ArrayList getFormalFilterTypesList() {
        return this.formalFilterTypesList;
    }

    public String getFormalFilterTypesString() {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.formalFilterTypesList.size(); ++i) {
            stringBuffer.append((String)this.formalFilterTypesList.get(i)).append(FILTER_TYPES_SEP);
        }
        string = stringBuffer.toString();
        if (string.endsWith(FILTER_TYPES_SEP)) {
            string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ArrayList getFormalFilterValuesList() {
        return this.formalFilterValuesList;
    }

    public void setFormalFilterValuesString(String string) {
        this.formalFilterValuesStr = string;
    }

    public String getFormalFilterValuesString() {
        return this.formalFilterValuesStr;
    }

    public ArrayList getFormalFilterDefaultValuesList() {
        return this.formalFilterDefaultValuesList;
    }

    public ArrayList getFormalFilterDisplayNamesList() {
        return this.formalFilterDisplayNamesList;
    }

    public ArrayList getUserFilterNamesList() {
        return this.userFilterNamesList;
    }

    public ArrayList getUserFilterExprList() {
        return this.userFilterExprList;
    }

    public ArrayList getUserFilterValuesList() {
        return this.userFilterValuesList;
    }

    public String getUserFilterValuesString() {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.userFilterValuesList.size(); ++i) {
            stringBuffer.append((String)this.userFilterValuesList.get(i)).append(FILTER_VALUES_SEP);
        }
        string = stringBuffer.toString();
        if (string.endsWith(FILTER_VALUES_SEP)) {
            string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ArrayList getDefaultOptList() {
        return this.defaultOptList;
    }

    private void setITMFilterComp() throws ITMException {
        try {
            InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
            if (this.itmFilterComp == null) {
                this.itmFilterComp = (ITMFilterRemote)initialContext.lookup("ibase/ITMFilterEJB/remote");
            }
        }
        catch (ITMException iTMException) {
            System.out.println("ITMException :ITMFilterBean :setITMFilterComp :==>\n" + iTMException.getMessage());
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception :ITMFilterBean :setITMFilterComp :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void setFormalFilterInfoStr() throws ITMException {
        try {
            this.formalFilterInfoStr = this.itmFilterComp.getFilterInfoString(this.objName);
            this.createXmlVals();
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
    }

    private void setUserFilterInfoStr() throws ITMException {
        String string = "";
        try {
            AppConnectParm appConnectParm = new AppConnectParm();
            InitialContext initialContext = new InitialContext(appConnectParm.getProperty());
            if (this.userInfo != null) {
                DBAccessRemote dBAccessRemote = (DBAccessRemote)initialContext.lookup("ibase/DBAccessEJB/remote");
                System.out.println("userInfo :[" + this.userInfo + "]");
                string = dBAccessRemote.getUserInfoString(this.objName, this.userInfo.getLoginCode(), this.userInfo.getProfileId(), this.userInfo.getUserLevel());
                this.setUserFilterData(string);
            } else {
                string = "ERR_MSG :User Info not in session";
            }
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
    }

    public ArrayList getPeriodInfoList() throws ITMException {
        ArrayList arrayList = null;
        try {
            GenericUtility genericUtility = new GenericUtility();
            arrayList = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            Document document = genericUtility.parseString(this.formalFilterInfoStr);
            NodeList nodeList = document.getElementsByTagName("PERIOD");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeName().equalsIgnoreCase("CODE")) {
                        arrayList2.add(node2.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (node2.getNodeName().equalsIgnoreCase("FR_DATE")) {
                        string = genericUtility.getValidDateString(node2.getFirstChild().getNodeValue(), genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                        arrayList3.add(string);
                        continue;
                    }
                    if (!node2.getNodeName().equalsIgnoreCase("TO_DATE")) continue;
                    string = genericUtility.getValidDateString(node2.getFirstChild().getNodeValue(), genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                    arrayList4.add(string);
                }
            }
            arrayList.add(arrayList2);
            arrayList.add(arrayList3);
            arrayList.add(arrayList4);
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return arrayList;
    }

    public String getPrdCode() throws ITMException {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            Document document = new GenericUtility().parseString(this.formalFilterInfoStr);
            NodeList nodeList = document.getElementsByTagName("DEFAULT_CODE");
            if (nodeList.item(0) != null) {
                string = nodeList.item(0).getFirstChild().getNodeValue();
            }
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }

    public void createXmlVals() throws ITMException {
        String string = null;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        try {
            GenericUtility genericUtility = new GenericUtility();
            Document document = genericUtility.parseString(this.formalFilterInfoStr);
            NodeList nodeList = document.getElementsByTagName("FORMALARG");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                string = node.getAttributes().getNamedItem("field_name").getNodeValue();
                string2 = node.getAttributes().getNamedItem("name").getNodeValue();
                string3 = node.getAttributes().getNamedItem("javatype").getNodeValue();
                System.out.println(string + " *****" + string2 + "*******" + string3);
                String string4 = "";
                Node node2 = node.getFirstChild();
                if (node2 != null && node2.getFirstChild() != null) {
                    string4 = node2.getFirstChild().getNodeValue();
                    if (string3.equalsIgnoreCase("date")) {
                        string4 = genericUtility.getValidDateString(string4, genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                    } else if (string3.equalsIgnoreCase("datetime")) {
                        string4 = genericUtility.getValidDateString(string4, genericUtility.getApplDateTimeFormat(), genericUtility.getDispDateFormat());
                    }
                } else {
                    string4 = "";
                }
                arrayList.add(string);
                arrayList2.add(string2);
                arrayList3.add(string3);
                arrayList4.add(string4);
            }
            this.formalFilterNamesList = arrayList;
            this.formalFilterDisplayNamesList = arrayList2;
            this.formalFilterTypesList = arrayList3;
            this.formalFilterDefaultValuesList = arrayList4;
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
    }

    private void setUserFilterData(String string) throws Exception {
        try {
            Document document = new GenericUtility().parseString(string);
            NodeList nodeList = document.getElementsByTagName("filter");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2 = nodeList.item(i).getAttributes().getNamedItem("default_opt").getNodeValue();
                this.defaultOptList.add(i, string2);
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (nodeList2.item(j).getFirstChild() == null) continue;
                    if (nodeList2.item(j).getNodeName().equals("name")) {
                        this.userFilterNamesList.add(i, nodeList2.item(j).getFirstChild().getNodeValue());
                    }
                    if (!nodeList2.item(j).getNodeName().equals("expr")) continue;
                    this.userFilterExprList.add(i, nodeList2.item(j).getFirstChild().getNodeValue());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public String replaceQestMark(String string, int n, String string2) throws Exception {
        String string3 = string;
        String string4 = "";
        int n2 = 0;
        while (string3.indexOf(63) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            int n3 = stringBuffer2.toString().indexOf(63);
            int n4 = stringBuffer.toString().indexOf(63);
            stringBuffer.replace(n4, n4 + 1, "<input type='text' id='textSpan" + n + n2 + "' size = '30' style='border:solid 1;border-color:lightgrey;font-family:Tahoma;font-size: 12' onFocus='selectedCheckBox(this)' typedata='" + this.assignType(stringBuffer2.toString()) + "'/>");
            stringBuffer2.replace(n3, n3 + 1, "A");
            string2 = stringBuffer2.toString();
            stringBuffer2 = null;
            string3 = stringBuffer.toString();
            stringBuffer = null;
            ++n2;
        }
        return string3;
    }

    private String assignType(String string) throws Exception {
        int n;
        String string2 = "";
        ArgumentBean argumentBean = new ArgumentBean();
        argumentBean.setObjName(this.objName);
        argumentBean.setColumnsInfo();
        ArrayList arrayList = argumentBean.getPhysicalNameList();
        ArrayList arrayList2 = argumentBean.getUserFilterTypeList();
        String[] stringArray = string.split(" ");
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println("----filterToken[i]--" + stringArray[n]);
        }
        for (n = 0; n < stringArray.length; n += 6) {
            int n2 = this.getIndex(stringArray[n], arrayList);
            if (!stringArray[n + 4].equals("'?'")) continue;
            string2 = (String)arrayList2.get(n2);
            break;
        }
        return string2;
    }

    private int getIndex(String string, ArrayList arrayList) throws Exception {
        int n = -1;
        if (string.trim().startsWith("(")) {
            string = string.substring(string.indexOf("(") + 1, string.length());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equals((String)arrayList.get(i))) continue;
            n = i;
            break;
        }
        return n;
    }
}

