package ibase.webitm.ejb.adm.adv;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@Stateless
public class EmpBondDefault extends ActionHandlerEJB implements  EmpBondDefaultLocal,EmpBondDefaultRemote
{
	 public String actionHandler(String actionType, String xmlString, String objContext, String xtraParams) throws RemoteException, ITMException
	    {
		 	Document dom = null;
			GenericUtility genericUtility = GenericUtility.getInstance();
			String retString = "";
			try
			{
			    dom = genericUtility.parseString(xmlString);
			    retString = actionHandler(actionType, dom, objContext, xtraParams);			    
			}
			catch (Exception ex)
			{
				System.out.println("in catch");
			    ex.printStackTrace();
			    throw new ITMException(ex);
			}
			
			return retString;
	    }
	 private String actionHandler(String actionType, Document dom, String objContext, String xtraParams) throws ITMException
	 {
		 String sql = "", childNodeName = "";
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			ConnDriver connDriver = new ConnDriver();
			NodeList parentNodeList = null, childNodeList = null;
			Node parentNode = null, childNode = null;
			
			int bondAmt=0,bondPrd=0;
			GenericUtility genericUtility;
			StringBuffer valueXmlBuff;
			String retString = "",empcode="", userId = "";
			ValidatorEJB validatorEJB;
			String emp="";
			int lineNo=0;
			try
			{
			    validatorEJB = new ValidatorEJB();
			    userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			    valueXmlBuff = new StringBuffer();
			    genericUtility = GenericUtility.getInstance();
			  
			    empcode =genericUtility.getColumnValue("emp_code",dom);
				valueXmlBuff.append("<?xml version=\"1.0\"?>\r\n");
				valueXmlBuff.append("<Root>\r\n");

				parentNodeList = dom.getElementsByTagName("Detail1");
				//loginEmpCode = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
				
			   
			    for (int i = 0; i < parentNodeList.getLength(); i++)
				{
				    parentNode = parentNodeList.item(i);
				    childNodeList = parentNode.getChildNodes();

				    for (int j = 0; j < childNodeList.getLength(); j++)
				    {
						childNode = childNodeList.item(j);
						childNodeName = childNode.getNodeName();							
					}
				}
			    
			    conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				
				sql="select e.line_no,e.bond_prd,e.bond_amt from employee_bond e where e.emp_code=?";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, empcode);
				rs = pstmt.executeQuery();
				
				while (rs.next())
				{
				   // lineNo++;	
				    lineNo=rs.getInt("LINE_NO");
				    bondAmt = rs.getInt("BOND_AMT");
				    bondPrd = rs.getInt("BOND_PRD");
						
					valueXmlBuff.append("<Detail>\r\n");					
					valueXmlBuff.append("<line_no>").append("<![CDATA["+lineNo+"]]>").append("</line_no>");
					valueXmlBuff.append("<bond_amt__curr>").append("<![CDATA["+bondAmt+"]]>").append("</bond_amt__curr>");
					valueXmlBuff.append("<bond_prd__curr>").append("<![CDATA["+bondPrd+"]]>").append("</bond_prd__curr>");
					
					valueXmlBuff.append("<bond_amt>").append("<![CDATA["+bondAmt+"]]>").append("</bond_amt>");
					valueXmlBuff.append("<bond_prd>").append("<![CDATA["+bondPrd+"]]>").append("</bond_prd>");
					
					valueXmlBuff.append("</Detail>\r\n");
					System.out.println("------->>>>Line no :"+lineNo+" Bond Amt :"+bondAmt+" bond period : "+bondPrd);			
				}
				
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				valueXmlBuff.append("</Root>\r\n");
				retString = valueXmlBuff.toString();		
				
			    System.out.println("Return String ..in deafault EJB ----------->>>>>>>>>>> \n" + retString);
			    return retString;
			}
			catch (Exception e)
			{
			    System.out.println("Exception : TrainingDefault : actionHandler " + e.getMessage());
			    e.printStackTrace();
			    throw new ITMException(e);
			}
			finally
			{
			    try
			    {
				if (conn != null)
				{
				    conn.close();
				    conn = null;
				}
				if (pstmt != null)
				{
				    pstmt.close();
				    pstmt = null;
				}
			    }
			    catch (Exception e)
			    {
				e.printStackTrace();
			    }
			}
			//return retString;
	 }
}