/********************************************************
	Title 	 : BomAltAmdConf
	Date  	 : 29/01/14
	Developer: Sagar Mane
    Request id:MF3JSUN002
********************************************************/
package ibase.webitm.ejb.mfg.adv;

import java.rmi.RemoteException;


import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.*;
import java.sql.*;
import java.text.SimpleDateFormat;

import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;
import java.util.Calendar;

import java.util.Date;

@Stateless
public class BomAltAmdConf extends ActionHandlerEJB implements BomAltAmdConfLocal, BomAltAmdConfRemote
{
	public String confirm(String amdNo, String xtraParams, String forcedFlag)throws RemoteException, ITMException
			{
		System.out.println(">>>>>>>>>>>>>>>>>>BomAltAmdConf confirm called>>>>>>>>>>>>>>>>>>>");
		String confirmed = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
	    String errString = null;
		ResultSet rs = null;
		String loginEmpCode="";
		String bomCode="",itemCode="",itemRef="",itemCodeAlt="",suppCodeMfgNew="";
	    int cnt = 0,updCnt1=0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		Timestamp sysDate = null,amddate=null;
		GenericUtility genericUtility = GenericUtility.getInstance();

		try 
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (amdNo != null && amdNo.trim().length() > 0) 
			{
				System.out.println("@@@@@amdNo"+amdNo+"]");

				sql = "	select confirmed,amd_date,bom_code,item_code,item_ref,item_code__alt,supp_code__mfg from  bom_alt_amd where amd_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, amdNo);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{

					confirmed = rs.getString("confirmed");
					amddate=rs.getTimestamp("amd_date");
					bomCode=rs.getString("bom_code");
					itemCode=rs.getString("item_code");
					itemRef=rs.getString("item_ref");
					itemCodeAlt=rs.getString("item_code__alt");
					suppCodeMfgNew=rs.getString("supp_code__mfg");
					 
					System.out.println(">>>>>>>>confirmed:"+confirmed);
					System.out.println(">>>>>>>>amddate:"+amddate);
					System.out.println(">>>>>>>>bomCode:"+bomCode);
					System.out.println(">>>>>>>>itemCode:"+itemCode);
					System.out.println(">>>>>>>>itemRef:"+itemRef);
					System.out.println(">>>>>>>>itemCodeAlt:"+itemCodeAlt);
					System.out.println(">>>>>>>>suppCodeMfgNew:"+suppCodeMfgNew);
					
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if ("Y".equalsIgnoreCase(confirmed)) 
				{	
					System.out.println("transaction already confirmed");				
					errString = itmDBAccessLocal.getErrorString("","VTCONF8","");
				
				}
				else
				{
					System.out.println(">>>>>>>>>>>>>>>>>>>>transaction not confirmed");

					loginEmpCode =  genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");							
					Calendar currentDate = Calendar.getInstance();
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String sysDateStr = sdf.format(currentDate.getTime());
					System.out.println("Now the date is :=>  " + sysDateStr);
					sysDate= Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");

					System.out.println(">>>>>>>>sysDate:"+sysDate);
					System.out.println(">>>>>>>>itemCodeAlt:"+loginEmpCode);
					
				   sql = " update bom_alt set supp_code__mfg=?,amd_no=?,amd_date=? where bom_code = ? and  item_code=? and item_ref=? and item_code__alt=? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, suppCodeMfgNew);
					pstmt.setString(2, amdNo);
					pstmt.setTimestamp(3, amddate);
					pstmt.setString(4, bomCode);
					pstmt.setString(5, itemCode);
					pstmt.setString(6, itemRef);
					pstmt.setString(7, itemCodeAlt);
					
					updCnt1 = pstmt.executeUpdate();
					pstmt.close();
				    pstmt = null;
				
				    if (updCnt1>0) 
					{	
				
				        sql = " update bom_alt_amd set confirmed = 'Y',conf_date = ?, emp_code__aprv = ? where amd_no = ? ";
				        pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, sysDate);
						pstmt.setString(2, loginEmpCode);
						pstmt.setString(3, amdNo);
						cnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
						System.out.println(">>>>>>>>>>>>>>>>>cnt:"+cnt);
						if (cnt>0) 
						{	

							errString = itmDBAccessLocal.getErrorString("","VTCNFSUCC","");

						}
						else
						{	
							errString = itmDBAccessLocal.getErrorString("","VTNCONFT","");
						}
                      
					}
					else
					{	
						System.out.println("not updated >>>>>>>>updCnt1>>>>>>>>>>>>:"+updCnt1);
						errString = itmDBAccessLocal.getErrorString("","VTNCONFT","");

					}

				}
			}


			// end if errstrng
		} catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{		
			try
			{
				if(errString != null && errString.trim().length() > 0)
				{
					System.out.println("--going to commit tranaction--");
					if(errString.indexOf("VTCNFSUCC") > -1)

					{
						conn.commit();
						System.out.println("--transaction commited--");
					}
					else
					{
						conn.rollback();
						System.out.println("--transaction rollback--");
					}
				}

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}



		return errString;
	
	}
	private String checknull(String string)
	{
		if (string == null) 
		{
			string = "";
		}
		return string;
	}


}